"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const prosemirror_commands_1 = require("prosemirror-commands");
const prosemirror_math_1 = require("@benrbray/prosemirror-math");
const Node_1 = __importDefault(require("./Node"));
require("katex/dist/katex.min.css");
require("@benrbray/prosemirror-math/style/math.css");
class Math extends Node_1.default {
    get name() {
        return "math_inline";
    }
    get schema() {
        return {
            group: "inline math",
            content: "text*",
            inline: true,
            atom: true,
            toDOM: () => [
                "math-inline",
                { class: "math-node", spellcheck: "false" },
                0,
            ],
            parseDOM: [
                {
                    tag: "math-inline",
                },
            ],
        };
    }
    commands({ type }) {
        return () => prosemirror_math_1.insertMathCmd(type);
    }
    inputRules({ schema }) {
        return [
            prosemirror_math_1.makeInlineMathInputRule(prosemirror_math_1.REGEX_INLINE_MATH_DOLLARS, schema.nodes.math_inline),
        ];
    }
    keys({ type }) {
        return {
            "Mod-Space": prosemirror_math_1.insertMathCmd(type),
            Backspace: prosemirror_commands_1.chainCommands(prosemirror_commands_1.deleteSelection, prosemirror_math_1.mathBackspaceCmd, prosemirror_commands_1.joinBackward, prosemirror_commands_1.selectNodeBackward),
        };
    }
    get plugins() {
        return [prosemirror_math_1.mathPlugin];
    }
    toMarkdown(state, node) {
        state.write("$");
        state.renderInline(node);
        state.write("$");
    }
    parseMarkdown() {
        return {
            node: "math_inline",
        };
    }
}
exports.default = Math;
//# sourceMappingURL=Math.js.map