"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const prosemirror_math_1 = require("@benrbray/prosemirror-math");
const Node_1 = __importDefault(require("./Node"));
class MathDisplay extends Node_1.default {
    get name() {
        return "math_display";
    }
    get schema() {
        return {
            group: "block math",
            content: "text*",
            atom: true,
            code: true,
            toDOM: () => [
                "math-display",
                { class: "math-node", spellcheck: "false" },
                0,
            ],
            parseDOM: [
                {
                    tag: "math-display",
                },
            ],
        };
    }
    commands({ type }) {
        console.log(type);
        return () => prosemirror_math_1.insertMathCmd(type);
    }
    inputRules({ type }) {
        return [prosemirror_math_1.makeBlockMathInputRule(prosemirror_math_1.REGEX_BLOCK_MATH_DOLLARS, type)];
    }
    toMarkdown(state, node) {
        state.write("$$\n");
        state.text(node.textContent, false);
        state.ensureNewLine();
        state.write("$$");
        state.closeBlock(node);
    }
    parseMarkdown() {
        return {
            node: "math_display",
        };
    }
}
exports.default = MathDisplay;
//# sourceMappingURL=MathDisplay.js.map