import getLineAndColumnByPosition from './get-line-and-column-by-position'
import {execute as runPreprocessor} from '../preprocessors'

/**
 * Preprocess a riot parser node
 * @param   { string } preprocessorType - either css, js
 * @param   { string } preprocessorName - preprocessor id
 * @param   { Object } options - options that will be passed to the compiler
 * @param   { string } source - tag source code
 * @param   { RiotParser.nodeTypes } node - css node detected by the parser
 * @returns { Output } code and sourcemap generated by the preprocessor
 */
export default async function preprocess(preprocessorType, preprocessorName, options, source, node) {
  const { column } = getLineAndColumnByPosition(source, node.start)
  const offsetTop = '\n'.repeat(column)
  const code = `${offsetTop}\n${node.text}`

  return await (preprocessorName ?
    runPreprocessor(preprocessorType, preprocessorName, options, code) :
    { code }
  )
}