/* Riot v7.1.0, @license MIT */
import { IS_DIRECTIVE } from '../node_modules/@riotjs/util/constants.js';
import { getName } from '../utils/dom.js';
import { set } from '../node_modules/bianco.attr/index.next.js';

/**
 * Add eventually the "is" attribute to link this DOM node to its css
 * @param {HTMLElement} element - target root node
 * @param {string} name - name of the component mounted
 * @returns {undefined} it's a void function
 */

function addCssHook(element, name) {
  if (getName(element) !== name) {
    set(element, IS_DIRECTIVE, name);
  }
}

export { addCssHook };
