/* Riot v7.1.0, @license MIT */
import { PLUGINS_SET } from '../node_modules/@riotjs/util/constants.js';

/**
 * Run the component instance through all the plugins set by the user
 * @param   {Object} component - component instance
 * @returns {Object} the component enhanced by the plugins
 */
function runPlugins(component) {
  return [...PLUGINS_SET].reduce((c, fn) => fn(c) || c, component);
}

export { runPlugins };
