'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var DefaultDecorators = [{
    component: function (_React$Component) {
        (0, _inherits3['default'])(component, _React$Component);

        function component() {
            (0, _classCallCheck3['default'])(this, component);

            var _this = (0, _possibleConstructorReturn3['default'])(this, (component.__proto__ || Object.getPrototypeOf(component)).apply(this, arguments));

            _this.handleClick = function (e) {
                e.preventDefault();
                _this.props.previousSlide();
            };
            return _this;
        }

        (0, _createClass3['default'])(component, [{
            key: 'render',
            value: function render() {
                return _react2['default'].createElement(
                    'button',
                    { style: this.getButtonStyles(this.props.currentSlide === 0 && !this.props.wrapAround), onClick: this.handleClick },
                    'PREV'
                );
            }
        }, {
            key: 'getButtonStyles',
            value: function getButtonStyles(disabled) {
                return {
                    border: 0,
                    background: 'rgba(0,0,0,0.4)',
                    color: 'white',
                    padding: 10,
                    outline: 0,
                    opacity: disabled ? 0.3 : 1,
                    cursor: 'pointer'
                };
            }
        }]);
        return component;
    }(_react2['default'].Component),
    position: 'CenterLeft'
}, {
    component: function (_React$Component2) {
        (0, _inherits3['default'])(component, _React$Component2);

        function component() {
            (0, _classCallCheck3['default'])(this, component);

            var _this2 = (0, _possibleConstructorReturn3['default'])(this, (component.__proto__ || Object.getPrototypeOf(component)).apply(this, arguments));

            _this2.handleClick = function (e) {
                e.preventDefault();
                if (_this2.props.nextSlide) {
                    _this2.props.nextSlide();
                }
            };
            return _this2;
        }

        (0, _createClass3['default'])(component, [{
            key: 'render',
            value: function render() {
                return _react2['default'].createElement(
                    'button',
                    { style: this.getButtonStyles(this.props.currentSlide + this.props.slidesToScroll >= this.props.slideCount && !this.props.wrapAround), onClick: this.handleClick },
                    'NEXT'
                );
            }
        }, {
            key: 'getButtonStyles',
            value: function getButtonStyles(disabled) {
                return {
                    border: 0,
                    background: 'rgba(0,0,0,0.4)',
                    color: 'white',
                    padding: 10,
                    outline: 0,
                    opacity: disabled ? 0.3 : 1,
                    cursor: 'pointer'
                };
            }
        }]);
        return component;
    }(_react2['default'].Component),
    position: 'CenterRight'
}, {
    component: function (_React$Component3) {
        (0, _inherits3['default'])(component, _React$Component3);

        function component() {
            (0, _classCallCheck3['default'])(this, component);
            return (0, _possibleConstructorReturn3['default'])(this, (component.__proto__ || Object.getPrototypeOf(component)).apply(this, arguments));
        }

        (0, _createClass3['default'])(component, [{
            key: 'render',
            value: function render() {
                var _this4 = this;

                var indexes = this.getIndexes(this.props.slideCount, this.props.slidesToScroll);
                return _react2['default'].createElement(
                    'ul',
                    { style: this.getListStyles() },
                    indexes.map(function (index) {
                        return _react2['default'].createElement(
                            'li',
                            { style: _this4.getListItemStyles(), key: index },
                            _react2['default'].createElement(
                                'button',
                                { style: _this4.getButtonStyles(_this4.props.currentSlide === index), onClick: _this4.props.goToSlide && _this4.props.goToSlide.bind(null, index) },
                                '\u2022'
                            )
                        );
                    })
                );
            }
        }, {
            key: 'getIndexes',
            value: function getIndexes(count, inc) {
                var arr = [];
                for (var i = 0; i < count; i += inc) {
                    arr.push(i);
                }
                return arr;
            }
        }, {
            key: 'getListStyles',
            value: function getListStyles() {
                return {
                    position: 'relative',
                    margin: 0,
                    top: -10,
                    padding: 0
                };
            }
        }, {
            key: 'getListItemStyles',
            value: function getListItemStyles() {
                return {
                    listStyleType: 'none',
                    display: 'inline-block'
                };
            }
        }, {
            key: 'getButtonStyles',
            value: function getButtonStyles(active) {
                return {
                    border: 0,
                    background: 'transparent',
                    color: 'black',
                    cursor: 'pointer',
                    padding: 10,
                    outline: 0,
                    fontSize: 24,
                    opacity: active ? 1 : 0.5
                };
            }
        }]);
        return component;
    }(_react2['default'].Component),
    position: 'BottomCenter'
}];
exports['default'] = DefaultDecorators;
module.exports = exports['default'];