import * as RMWC from '@rmwc/types';
import React from 'react';
/** An Avatar component for displaying users in a system. */
export interface AvatarProps extends RMWC.WithRippleProps {
    /** The url for the image. This gets passed to the Icon component. */
    src?: string;
    /** The size of the avatar */
    size?: RMWC.IconSizeT;
    /** The name of the user. This will get converted to initials and set the hover title. */
    name?: string;
    /** Make the avatar square. */
    square?: boolean;
    /** Make the avatar interactive. */
    interactive?: boolean;
    /** Contain the avatar image instead of covering. */
    contain?: boolean;
}
/** A container for groups of Avatars */
export interface AvatarGroupProps {
    /** Makes the list dense */
    dense?: boolean;
}
/** A container for groups of Avatars */
export declare const AvatarGroup: {
    <Tag extends React.ElementType<any> = "div">(props: RMWC.ComponentProps<AvatarGroupProps, React.HTMLProps<HTMLElement>, Tag>, ref: any): JSX.Element;
    displayName: string;
};
/** An Avatar component for displaying users in a system. */
export declare const Avatar: {
    <Tag extends React.ElementType<any> = "div">(props: RMWC.ComponentProps<AvatarProps, React.HTMLProps<HTMLElement>, Tag>, ref: any): JSX.Element;
    displayName: string;
};
/** An Avatar count for displaying list overflow. */
export interface AvatarCountProps {
    /** The number of users. */
    value: number;
    /** Optionally renders a "+" to indicate overlow. */
    overflow?: boolean;
    /** The size of the avatar */
    size?: RMWC.IconSizeT;
    /** Make the avatar square. */
    square?: boolean;
    /** Make the avatar interactive. */
    interactive?: boolean;
}
/** An Avatar count for displaying list overflow. */
export declare const AvatarCount: {
    <Tag extends React.ElementType<any> = "div">(props: RMWC.ComponentProps<AvatarCountProps, React.HTMLProps<HTMLDivElement>, Tag>, ref: any): JSX.Element;
    displayName: string;
};
