"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvatarCount = exports.Avatar = exports.AvatarGroup = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var icon_1 = require("@rmwc/icon");
var ripple_1 = require("@rmwc/ripple");
var base_1 = require("@rmwc/base");
var getInitialsForName = function (name) {
    if (name) {
        var parts = name.split(' ');
        /* istanbul ignore next */
        var letters = (parts[0] || '')[0];
        if (parts.length > 1) {
            var part = parts.pop();
            /* istanbul ignore next */
            if (part) {
                letters += part[0];
            }
        }
        return letters;
    }
    return '';
};
var AvatarRoot = ripple_1.withRipple()(base_1.createMemoComponent(function AvatarRoot(props, ref) {
    var _a;
    var isCount = props.isCount, overflow = props.overflow, smallerText = props.smallerText, square = props.square, interactive = props.interactive, hasImage = props.hasImage, rest = tslib_1.__rest(props, ["isCount", "overflow", "smallerText", "square", "interactive", "hasImage"]);
    var className = base_1.useClassNames(props, [
        'rmwc-avatar',
        (_a = {},
            _a["rmwc-avatar--" + props.size] = rest.size,
            _a['rmwc-avatar--count'] = isCount,
            _a['rmwc-avatar--interactive'] = interactive,
            _a['rmwc-avatar--count-overflow'] = overflow,
            _a['rmwc-avatar--smaller-text'] = smallerText,
            _a['rmwc-avatar--square'] = square,
            _a['rmwc-avatar--has-image'] = hasImage,
            _a)
    ]);
    return react_1.default.createElement(icon_1.Icon, tslib_1.__assign({}, rest, { className: className, ref: ref }));
}));
AvatarRoot.displayName = 'AvatarRoot';
/** A container for groups of Avatars */
exports.AvatarGroup = base_1.createComponent(function AvatarGroup(props, ref) {
    var dense = props.dense, rest = tslib_1.__rest(props, ["dense"]);
    var className = base_1.useClassNames(props, [
        'rmwc-avatar-group',
        {
            'rmwc-avatar-group--dense': dense
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, className: className }));
});
/** An Avatar component for displaying users in a system. */
exports.Avatar = base_1.createComponent(function Avatar(_a, ref) {
    var src = _a.src, size = _a.size, _b = _a.name, name = _b === void 0 ? '' : _b, _c = _a.interactive, interactive = _c === void 0 ? false : _c, _d = _a.contain, contain = _d === void 0 ? false : _d, rest = tslib_1.__rest(_a, ["src", "size", "name", "interactive", "contain"]);
    var initials = getInitialsForName(name);
    var avatarStyle = src
        ? {
            backgroundImage: "url(" + src + ")",
            backgroundSize: contain ? 'contain' : 'cover'
        }
        : {};
    return (react_1.default.createElement(AvatarRoot, tslib_1.__assign({ ref: ref, ripple: interactive, interactive: interactive, hasImage: !!src, size: size, title: name, tag: 'span' }, rest, { icon: {
            icon: (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("div", { className: "rmwc-avatar__icon", style: avatarStyle }),
                react_1.default.createElement("div", { className: "rmwc-avatar__text" },
                    react_1.default.createElement("div", { className: "rmwc-avatar__text-inner" }, initials))))
        } })));
});
exports.Avatar.displayName = 'Avatar';
/** An Avatar count for displaying list overflow. */
exports.AvatarCount = base_1.createMemoComponent(function AvatarCount(_a, ref) {
    var value = _a.value, overflow = _a.overflow, size = _a.size, _b = _a.interactive, interactive = _b === void 0 ? false : _b, rest = tslib_1.__rest(_a, ["value", "overflow", "size", "interactive"]);
    var smallerText = String(value).length > 2;
    return (react_1.default.createElement(AvatarRoot, tslib_1.__assign({ ref: ref, ripple: interactive, interactive: interactive, isCount: true, size: size, overflow: overflow, smallerText: smallerText, tag: 'span' }, rest, { icon: {
            icon: (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("div", { className: "rmwc-avatar__text" },
                    react_1.default.createElement("div", { className: "rmwc-avatar__text-inner" }, value))))
        } })));
});
