"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
var button_1 = require("../button");
var chip_1 = require("../chip");
var textfield_1 = require("../textfield");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Avatars", lead: "Avatars are virtual representations of users in a system.", module: "@rmwc/avatar", styles: [
            '@rmwc/avatar/avatar.css',
            '@rmwc/icon/icon.css',
            '@material/ripple/dist/mdc.ripple.css'
        ], examples: generated_examples_json_1.default, addon: true },
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Images" },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/blackwidow.png", size: "xsmall", name: "Natalia Alianovna Romanova" }),
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/hulk.png", size: "small", name: "Bruce Banner" }),
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/thor.png", size: "medium", name: "Thor Odinson" }),
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/captainamerica.png", size: "large", name: "Steve Rogers" }),
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/ironman.png", size: "xlarge", name: "Tony Stark" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Initials Only" },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.Avatar, { name: "Natalia Alianovna Romanova", size: "xsmall" }),
                react_1.default.createElement(_1.Avatar, { name: "Bruce Banner", size: "small" }),
                react_1.default.createElement(_1.Avatar, { name: "Thor Odinson", size: "medium" }),
                react_1.default.createElement(_1.Avatar, { name: "Steve Rogers", size: "large" }),
                react_1.default.createElement(_1.Avatar, { name: "Tony Stark", size: "xlarge" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Square Variant" },
            react_1.default.createElement(_1.Avatar, { src: "images/avatars/blackwidow.png", size: "large", name: "Natalia Alianovna Romanova", square: true })),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Contained" },
            react_1.default.createElement(_1.Avatar, { src: "images/avatars/google.svg", size: "large", contain: true, name: "Google", square: true })),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Avatar Groups"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "This is for Avatars that are displayed in a corellated grouping or list."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Standard" },
            react_1.default.createElement(_1.AvatarGroup, null,
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers", size: "large", interactive: true }),
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/ironman.png", name: "Tony Stark", size: "large", interactive: true }),
                react_1.default.createElement(_1.AvatarCount, { size: "large", value: 12, interactive: true }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Dense" },
            react_1.default.createElement(_1.AvatarGroup, { dense: true },
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers", size: "large", interactive: true }),
                react_1.default.createElement(_1.Avatar, { src: "images/avatars/ironman.png", name: "Tony Stark", size: "large", interactive: true }),
                react_1.default.createElement(_1.AvatarCount, { size: "large", overflow: true, value: 4, interactive: true }))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Usage with other components"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "The avatar component has been designed to work nicely in any of the places you would use an icon."),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(button_1.Button, { label: "Enlist now!", icon: react_1.default.createElement(_1.Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers" }) })),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(chip_1.Chip, { label: "Hulk Smash", icon: react_1.default.createElement(_1.Avatar, { src: "images/avatars/hulk.png", name: "Bruce Banner" }) })),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(textfield_1.TextField, { label: "Message Natalia...", outlined: true, icon: react_1.default.createElement(_1.Avatar, { src: "images/avatars/blackwidow.png", name: "Natalia Alianovna Romanova", square: true }) })),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'Avatar', component: _1.Avatar },
                { displayName: 'AvatarGroup', component: _1.AvatarGroup },
                { displayName: 'AvatarCount', component: _1.AvatarCount }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(_1.AvatarGroup, { dense: true },
    react_1.default.createElement(_1.Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers", size: "large", interactive: true }),
    react_1.default.createElement(_1.Avatar, { src: "images/avatars/ironman.png", name: "Tony Stark", size: "large", interactive: true }),
    react_1.default.createElement(_1.AvatarCount, { size: "large", overflow: true, value: 4, interactive: true })));
