import { __assign, __rest } from "tslib";
import React from 'react';
import { Icon } from '@rmwc/icon';
import { withRipple } from '@rmwc/ripple';
import { useClassNames, Tag, createComponent, createMemoComponent } from '@rmwc/base';
var getInitialsForName = function (name) {
    if (name) {
        var parts = name.split(' ');
        /* istanbul ignore next */
        var letters = (parts[0] || '')[0];
        if (parts.length > 1) {
            var part = parts.pop();
            /* istanbul ignore next */
            if (part) {
                letters += part[0];
            }
        }
        return letters;
    }
    return '';
};
var AvatarRoot = withRipple()(createMemoComponent(function AvatarRoot(props, ref) {
    var _a;
    var isCount = props.isCount, overflow = props.overflow, smallerText = props.smallerText, square = props.square, interactive = props.interactive, hasImage = props.hasImage, rest = __rest(props, ["isCount", "overflow", "smallerText", "square", "interactive", "hasImage"]);
    var className = useClassNames(props, [
        'rmwc-avatar',
        (_a = {},
            _a["rmwc-avatar--" + props.size] = rest.size,
            _a['rmwc-avatar--count'] = isCount,
            _a['rmwc-avatar--interactive'] = interactive,
            _a['rmwc-avatar--count-overflow'] = overflow,
            _a['rmwc-avatar--smaller-text'] = smallerText,
            _a['rmwc-avatar--square'] = square,
            _a['rmwc-avatar--has-image'] = hasImage,
            _a)
    ]);
    return React.createElement(Icon, __assign({}, rest, { className: className, ref: ref }));
}));
AvatarRoot.displayName = 'AvatarRoot';
/** A container for groups of Avatars */
export var AvatarGroup = createComponent(function AvatarGroup(props, ref) {
    var dense = props.dense, rest = __rest(props, ["dense"]);
    var className = useClassNames(props, [
        'rmwc-avatar-group',
        {
            'rmwc-avatar-group--dense': dense
        }
    ]);
    return React.createElement(Tag, __assign({}, rest, { ref: ref, className: className }));
});
/** An Avatar component for displaying users in a system. */
export var Avatar = createComponent(function Avatar(_a, ref) {
    var src = _a.src, size = _a.size, _b = _a.name, name = _b === void 0 ? '' : _b, _c = _a.interactive, interactive = _c === void 0 ? false : _c, _d = _a.contain, contain = _d === void 0 ? false : _d, rest = __rest(_a, ["src", "size", "name", "interactive", "contain"]);
    var initials = getInitialsForName(name);
    var avatarStyle = src
        ? {
            backgroundImage: "url(" + src + ")",
            backgroundSize: contain ? 'contain' : 'cover'
        }
        : {};
    return (React.createElement(AvatarRoot, __assign({ ref: ref, ripple: interactive, interactive: interactive, hasImage: !!src, size: size, title: name, tag: 'span' }, rest, { icon: {
            icon: (React.createElement(React.Fragment, null,
                React.createElement("div", { className: "rmwc-avatar__icon", style: avatarStyle }),
                React.createElement("div", { className: "rmwc-avatar__text" },
                    React.createElement("div", { className: "rmwc-avatar__text-inner" }, initials))))
        } })));
});
Avatar.displayName = 'Avatar';
/** An Avatar count for displaying list overflow. */
export var AvatarCount = createMemoComponent(function AvatarCount(_a, ref) {
    var value = _a.value, overflow = _a.overflow, size = _a.size, _b = _a.interactive, interactive = _b === void 0 ? false : _b, rest = __rest(_a, ["value", "overflow", "size", "interactive"]);
    var smallerText = String(value).length > 2;
    return (React.createElement(AvatarRoot, __assign({ ref: ref, ripple: interactive, interactive: interactive, isCount: true, size: size, overflow: overflow, smallerText: smallerText, tag: 'span' }, rest, { icon: {
            icon: (React.createElement(React.Fragment, null,
                React.createElement("div", { className: "rmwc-avatar__text" },
                    React.createElement("div", { className: "rmwc-avatar__text-inner" }, value))))
        } })));
});
