import React from 'react';
import { Docs, DocsExample, DocProps, DocsSubtitle, DocsP } from '@doc-utils';
import propsSrc from './generated-props.json';
import examples from './generated-examples.json';
import { Avatar, AvatarGroup, AvatarCount } from '.';
import { Button } from '../button';
import { Chip } from '../chip';
import { TextField } from '../textfield';
export default function Readme() {
    return (React.createElement(Docs, { title: "Avatars", lead: "Avatars are virtual representations of users in a system.", module: "@rmwc/avatar", styles: [
            '@rmwc/avatar/avatar.css',
            '@rmwc/icon/icon.css',
            '@material/ripple/dist/mdc.ripple.css'
        ], examples: examples, addon: true },
        React.createElement(DocsExample, { label: "Images" },
            React.createElement(React.Fragment, null,
                React.createElement(Avatar, { src: "images/avatars/blackwidow.png", size: "xsmall", name: "Natalia Alianovna Romanova" }),
                React.createElement(Avatar, { src: "images/avatars/hulk.png", size: "small", name: "Bruce Banner" }),
                React.createElement(Avatar, { src: "images/avatars/thor.png", size: "medium", name: "Thor Odinson" }),
                React.createElement(Avatar, { src: "images/avatars/captainamerica.png", size: "large", name: "Steve Rogers" }),
                React.createElement(Avatar, { src: "images/avatars/ironman.png", size: "xlarge", name: "Tony Stark" }))),
        React.createElement(DocsExample, { label: "Initials Only" },
            React.createElement(React.Fragment, null,
                React.createElement(Avatar, { name: "Natalia Alianovna Romanova", size: "xsmall" }),
                React.createElement(Avatar, { name: "Bruce Banner", size: "small" }),
                React.createElement(Avatar, { name: "Thor Odinson", size: "medium" }),
                React.createElement(Avatar, { name: "Steve Rogers", size: "large" }),
                React.createElement(Avatar, { name: "Tony Stark", size: "xlarge" }))),
        React.createElement(DocsExample, { label: "Square Variant" },
            React.createElement(Avatar, { src: "images/avatars/blackwidow.png", size: "large", name: "Natalia Alianovna Romanova", square: true })),
        React.createElement(DocsExample, { label: "Contained" },
            React.createElement(Avatar, { src: "images/avatars/google.svg", size: "large", contain: true, name: "Google", square: true })),
        React.createElement(DocsSubtitle, null, "Avatar Groups"),
        React.createElement(DocsP, null, "This is for Avatars that are displayed in a corellated grouping or list."),
        React.createElement(DocsExample, { label: "Standard" },
            React.createElement(AvatarGroup, null,
                React.createElement(Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers", size: "large", interactive: true }),
                React.createElement(Avatar, { src: "images/avatars/ironman.png", name: "Tony Stark", size: "large", interactive: true }),
                React.createElement(AvatarCount, { size: "large", value: 12, interactive: true }))),
        React.createElement(DocsExample, { label: "Dense" },
            React.createElement(AvatarGroup, { dense: true },
                React.createElement(Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers", size: "large", interactive: true }),
                React.createElement(Avatar, { src: "images/avatars/ironman.png", name: "Tony Stark", size: "large", interactive: true }),
                React.createElement(AvatarCount, { size: "large", overflow: true, value: 4, interactive: true }))),
        React.createElement(DocsSubtitle, null, "Usage with other components"),
        React.createElement(DocsP, null, "The avatar component has been designed to work nicely in any of the places you would use an icon."),
        React.createElement(DocsExample, null,
            React.createElement(Button, { label: "Enlist now!", icon: React.createElement(Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers" }) })),
        React.createElement(DocsExample, null,
            React.createElement(Chip, { label: "Hulk Smash", icon: React.createElement(Avatar, { src: "images/avatars/hulk.png", name: "Bruce Banner" }) })),
        React.createElement(DocsExample, null,
            React.createElement(TextField, { label: "Message Natalia...", outlined: true, icon: React.createElement(Avatar, { src: "images/avatars/blackwidow.png", name: "Natalia Alianovna Romanova", square: true }) })),
        React.createElement(DocProps, { src: propsSrc, components: [
                { displayName: 'Avatar', component: Avatar },
                { displayName: 'AvatarGroup', component: AvatarGroup },
                { displayName: 'AvatarCount', component: AvatarCount }
            ] })));
}
export var galleryExample = (React.createElement(AvatarGroup, { dense: true },
    React.createElement(Avatar, { src: "images/avatars/captainamerica.png", name: "Steve Rogers", size: "large", interactive: true }),
    React.createElement(Avatar, { src: "images/avatars/ironman.png", name: "Tony Stark", size: "large", interactive: true }),
    React.createElement(AvatarCount, { size: "large", overflow: true, value: 4, interactive: true })));
