"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMemoComponent = exports.createComponent = exports.handleRef = exports.mergeRefs = exports.useClassNames = exports.Tag = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var classnames_1 = tslib_1.__importDefault(require("classnames"));
var with_theme_1 = require("./with-theme");
exports.Tag = react_1.default.forwardRef(function Tag(_a, ref) {
    var _b = _a.tag, TagEl = _b === void 0 ? 'div' : _b, theme = _a.theme, element = _a.element, rest = tslib_1.__rest(_a, ["tag", "theme", "element"]);
    var finalProps = element ? element.props(rest) : rest;
    var finalRef = element ? exports.mergeRefs(ref, element.setRef) : ref;
    return react_1.default.createElement(TagEl, tslib_1.__assign({}, finalProps, { ref: finalRef }));
});
var useClassNames = function (props, classNames) {
    return classnames_1.default.apply(void 0, tslib_1.__spreadArray(tslib_1.__spreadArray([props.className], tslib_1.__read((!!props.theme ? with_theme_1.parseThemeOptions(props.theme) : []))), tslib_1.__read((typeof classNames === 'function' ? classNames(props) : classNames))));
};
exports.useClassNames = useClassNames;
var mergeRefs = function () {
    var refs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        refs[_i] = arguments[_i];
    }
    return function (el) {
        var e_1, _a;
        try {
            for (var refs_1 = tslib_1.__values(refs), refs_1_1 = refs_1.next(); !refs_1_1.done; refs_1_1 = refs_1.next()) {
                var ref = refs_1_1.value;
                if (typeof ref === 'function') {
                    ref(el);
                }
                else if (ref && 'current' in ref) {
                    // @ts-ignore
                    ref.current = el;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (refs_1_1 && !refs_1_1.done && (_a = refs_1.return)) _a.call(refs_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
};
exports.mergeRefs = mergeRefs;
var handleRef = function (ref, value) {
    if (typeof ref === 'function') {
        ref(value);
    }
    else if (ref && 'current' in ref) {
        // @ts-ignore
        ref.current = value;
    }
};
exports.handleRef = handleRef;
function createComponent(Component) {
    var ForwardComponent = react_1.default.forwardRef(Component);
    // Interestingly enough, we only need this declaration
    // for a generic placeholder for typescript inference,
    // we don't actually have to pay the penalty for using it at runtime :)
    var WrappedComponent = function (props, ref) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    };
    WrappedComponent.displayName = Component.constructor.name || 'RMWCComponent';
    ForwardComponent.displayName = WrappedComponent.displayName;
    return ForwardComponent;
}
exports.createComponent = createComponent;
function createMemoComponent(Component) {
    var Comp = createComponent(Component);
    return react_1.default.memo(Comp);
}
exports.createMemoComponent = createMemoComponent;
