"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PortalChild = exports.Portal = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var react_dom_1 = tslib_1.__importDefault(require("react-dom"));
var PORTAL_ID = 'rmwcPortal';
function Portal() {
    var el = react_1.useRef(null);
    return react_1.default.createElement("div", { ref: el, id: PORTAL_ID });
}
exports.Portal = Portal;
function PortalChild(_a) {
    var children = _a.children, renderTo = _a.renderTo;
    var portalEl = react_1.useMemo(function () {
        if (typeof document === 'undefined') {
            return undefined;
        }
        var element = undefined;
        if (renderTo === true) {
            element = document.getElementById(PORTAL_ID) || undefined;
            !element &&
                console.warn('No default Portal found. Did you forget to include it in the root of your app? `import { Portal } from "@rmwc/base";`');
        }
        else if (typeof renderTo === 'string') {
            element = document.querySelector(renderTo) || undefined;
            !element &&
                console.warn("The selector you provided for renderToPortal \"" + renderTo + "\" didn't find any elements.");
        }
        else if (renderTo instanceof Element) {
            element = renderTo;
        }
        return element;
    }, [renderTo]);
    if (portalEl) {
        return react_dom_1.default.createPortal(children, portalEl);
    }
    return react_1.default.createElement(react_1.default.Fragment, null, children);
}
exports.PortalChild = PortalChild;
