"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArrayEmitter = exports.EventEmitter = void 0;
var tslib_1 = require("tslib");
var EventEmitter = /** @class */ (function () {
    function EventEmitter() {
        this.events_ = {};
    }
    EventEmitter.prototype.on = function (event, cb) {
        this.events_ = this.events_ || {};
        this.events_[event] = this.events_[event] || [];
        this.events_[event].push(cb);
    };
    EventEmitter.prototype.off = function (event, cb) {
        this.events_ = this.events_ || {};
        if (event in this.events_ === false)
            return;
        this.events_[event].splice(this.events_[event].indexOf(cb), 1);
    };
    EventEmitter.prototype.trigger = function (event) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        this.events_ = this.events_ || {};
        if (event in this.events_ === false)
            return;
        for (var i = 0; i < this.events_[event].length; i++) {
            this.events_[event][i].apply(this, Array.prototype.slice.call(arguments, 1));
        }
    };
    return EventEmitter;
}());
exports.EventEmitter = EventEmitter;
var ArrayEmitter = /** @class */ (function (_super) {
    tslib_1.__extends(ArrayEmitter, _super);
    function ArrayEmitter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.array = [];
        return _this;
    }
    ArrayEmitter.prototype.push = function () {
        var _a;
        var items = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            items[_i] = arguments[_i];
        }
        var rVal = (_a = this.array).push.apply(_a, tslib_1.__spreadArray([], tslib_1.__read(items)));
        this.trigger('change');
        return rVal;
    };
    ArrayEmitter.prototype.empty = function () {
        this.array.length = 0;
        this.trigger('change');
    };
    ArrayEmitter.prototype.remove = function (item) {
        var index = this.array.indexOf(item);
        if (index > -1) {
            this.array.splice(index, 1);
            this.trigger('change');
            return true;
        }
        return false;
    };
    return ArrayEmitter;
}(EventEmitter));
exports.ArrayEmitter = ArrayEmitter;
