"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matches = exports.closest = void 0;
var closest = function (element, selector) {
    if (element instanceof Element) {
        /* istanbul ignore else  */
        if (element && element.closest) {
            return element.closest(selector);
        }
        else {
            var el = element;
            while (el) {
                if (exports.matches(el, selector)) {
                    return el;
                }
                el = el.parentElement;
            }
        }
    }
    return null;
};
exports.closest = closest;
var matches = function (element, selector) {
    /* istanbul ignore next  */
    var nativeMatches = element.matches ||
        element.webkitMatchesSelector ||
        // @ts-ignore
        element.msMatchesSelector;
    return nativeMatches.call(element, selector);
};
exports.matches = matches;
