"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.raf = void 0;
/**
 * A helper for when we have multiple requestion animation frames
 * Usage:
 *  raf(() => doSomething, 3);
 */
var raf = function (callback, frames, _iteration) {
    if (frames === void 0) { frames = 1; }
    if (_iteration === void 0) { _iteration = 1; }
    window.requestAnimationFrame(function () {
        _iteration >= frames ? callback() : exports.raf(callback, frames, _iteration + 1);
    });
};
exports.raf = raf;
