"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withTheme = exports.parseThemeOptions = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var classnames_1 = tslib_1.__importDefault(require("classnames"));
var strings_1 = require("./utils/strings");
/**
 * Actually parses the theme options
 */
var parseThemeOptions = function (theme) {
    var themeItems = Array.isArray(theme) ? theme : [theme];
    return themeItems
        .filter(function (v) { return !!v; })
        .map(function (v) { return "mdc-theme--" + strings_1.toDashCase(v); });
};
exports.parseThemeOptions = parseThemeOptions;
/**
 * HOC that adds themeability to any component
 */
var withTheme = function (Component) {
    var HOC = function (_a) {
        var theme = _a.theme, className = _a.className, rest = tslib_1.__rest(_a, ["theme", "className"]);
        if (theme) {
            var classes = classnames_1.default(className, exports.parseThemeOptions(theme));
            return react_1.default.createElement(Component, tslib_1.__assign({ className: classes }, rest));
        }
        return react_1.default.createElement(Component, tslib_1.__assign({ className: className }, rest));
    };
    HOC.displayName = 'withTheme';
    return HOC;
};
exports.withTheme = withTheme;
