"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CardActionButton = exports.CardActionIcon = exports.CardActionIcons = exports.CardActionButtons = exports.CardActions = exports.CardPrimaryAction = exports.CardMediaContent = exports.CardMedia = exports.Card = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var ripple_1 = require("@rmwc/ripple");
var button_1 = require("@rmwc/button");
var icon_button_1 = require("@rmwc/icon-button");
var base_1 = require("@rmwc/base");
/** A Card Component */
exports.Card = base_1.createComponent(function Card(props, ref) {
    var outlined = props.outlined, rest = tslib_1.__rest(props, ["outlined"]);
    var className = base_1.useClassNames(props, [
        'mdc-card',
        {
            'mdc-card--outlined': outlined
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, className: className }));
});
/** Media area that displays a custom background-image with background-size: cover */
exports.CardMedia = base_1.createComponent(function CardMedia(props, ref) {
    var square = props.square, sixteenByNine = props.sixteenByNine, rest = tslib_1.__rest(props, ["square", "sixteenByNine"]);
    var className = base_1.useClassNames(props, [
        'mdc-card__media',
        {
            'mdc-card__media--square': square,
            'mdc-card__media--16-9': sixteenByNine
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "section" }, rest, { ref: ref, className: className }));
});
/** An absolutely-positioned box the same size as the media area, for displaying a title or icon on top of the background-image */
exports.CardMediaContent = base_1.createComponent(function CardMediaContent(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-card__media-content']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** The main clickable area for the primary content of the card */
exports.CardPrimaryAction = ripple_1.withRipple({
    surface: false
})(base_1.createComponent(function CardPrimaryAction(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-card__primary-action']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
}));
/** Row containing action buttons and/or icons */
exports.CardActions = base_1.createComponent(function CardActions(props, ref) {
    var fullBleed = props.fullBleed, rest = tslib_1.__rest(props, ["fullBleed"]);
    var className = base_1.useClassNames(props, [
        'mdc-card__actions',
        { 'mdc-card__actions--full-bleed': fullBleed }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "section" }, rest, { ref: ref, className: className }));
});
/** A group of action buttons, displayed on the left side of the card (in LTR), adjacent to CardActionIcons */
exports.CardActionButtons = base_1.createComponent(function CardActionButtons(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-card__action-buttons']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A group of supplemental action icons, displayed on the right side of the card (in LTR), adjacent to CardActionButtons */
exports.CardActionIcons = base_1.createComponent(function CardActionIcons(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-card__action-icons']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A card action Icon */
exports.CardActionIcon = base_1.createComponent(function CardActionIcon(props, ref) {
    var className = base_1.useClassNames(props, [
        'mdc-card__action',
        'mdc-card__action--icon'
    ]);
    return react_1.default.createElement(icon_button_1.IconButton, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A card action Button */
exports.CardActionButton = base_1.createComponent(function CardActionIcon(props, ref) {
    var className = base_1.useClassNames(props, [
        'mdc-card__action',
        'mdc-card__action--button'
    ]);
    return react_1.default.createElement(button_1.Button, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
