"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
var typography_1 = require("../typography");
var list_1 = require("../list");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Cards", lead: "Cards contain content and actions about a single subject.", module: "@rmwc/card", styles: [
            '@material/card/dist/mdc.card.css',
            '@material/button/dist/mdc.button.css',
            '@material/icon-button/dist/mdc.icon-button.css'
        ], docsLink: "https://material.io/develop/web/components/cards/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Fully Featured Example"),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Card, { style: { width: '21rem' } },
                react_1.default.createElement(_1.CardPrimaryAction, null,
                    react_1.default.createElement(_1.CardMedia, { sixteenByNine: true, style: {
                            backgroundImage: 'url(images/backgrounds/mb-bg-fb-16.png)'
                        } }),
                    react_1.default.createElement("div", { style: { padding: '0 1rem 1rem 1rem' } },
                        react_1.default.createElement(typography_1.Typography, { use: "headline6", tag: "h2" }, "Our Changing Planet"),
                        react_1.default.createElement(typography_1.Typography, { use: "subtitle2", tag: "h3", theme: "textSecondaryOnBackground", style: { marginTop: '-1rem' } }, "by Kurt Wagner"),
                        react_1.default.createElement(typography_1.Typography, { use: "body1", tag: "div", theme: "textSecondaryOnBackground" }, "Visit ten places on our planet that are undergoing the biggest changes today."))),
                react_1.default.createElement(_1.CardActions, null,
                    react_1.default.createElement(_1.CardActionButtons, null,
                        react_1.default.createElement(_1.CardActionButton, null, "Read"),
                        react_1.default.createElement(_1.CardActionButton, null, "Bookmark")),
                    react_1.default.createElement(_1.CardActionIcons, null,
                        react_1.default.createElement(_1.CardActionIcon, { onIcon: "favorite", icon: "favorite_border" }),
                        react_1.default.createElement(_1.CardActionIcon, { icon: "share" }),
                        react_1.default.createElement(_1.CardActionIcon, { icon: "more_vert" }))))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Article Preview Example"),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Card, { outlined: true, style: { width: '21rem' } },
                react_1.default.createElement(typography_1.Typography, { use: "subtitle1", tag: "div", style: { padding: '0.5rem 1rem' }, theme: "textSecondaryOnBackground" }, "Headlines"),
                react_1.default.createElement(list_1.ListDivider, null),
                react_1.default.createElement(_1.CardPrimaryAction, null,
                    react_1.default.createElement("div", { style: { padding: '1rem' } },
                        react_1.default.createElement(typography_1.Typography, { use: "headline5", tag: "div" }, "Copper on the rise"),
                        react_1.default.createElement(typography_1.Typography, { use: "body1", tag: "p", theme: "textSecondaryOnBackground" }, "Copper price soars amid global market optimism and increased demand."))),
                react_1.default.createElement(list_1.ListDivider, null),
                react_1.default.createElement(_1.CardPrimaryAction, null,
                    react_1.default.createElement("div", { style: { padding: '1rem' } },
                        react_1.default.createElement(typography_1.Typography, { use: "headline5", tag: "div" }, "U.S. tech startups rebound"),
                        react_1.default.createElement(typography_1.Typography, { use: "body1", tag: "p", theme: "textSecondaryOnBackground" }, "Favorable business conditions have allowed startups to secure more fundraising deals compared to last year."))),
                react_1.default.createElement(list_1.ListDivider, null),
                react_1.default.createElement(_1.CardPrimaryAction, null,
                    react_1.default.createElement("div", { style: { padding: '1rem' } },
                        react_1.default.createElement(typography_1.Typography, { use: "headline5", tag: "div" }, "Asia's clean energy ambitions"),
                        react_1.default.createElement(typography_1.Typography, { use: "body1", tag: "p", theme: "textSecondaryOnBackground" }, "China plans to invest billions of dollars for the development of over 300 clean energy projects in Southeast Asia."))),
                react_1.default.createElement(list_1.ListDivider, null),
                react_1.default.createElement(_1.CardActions, { fullBleed: true },
                    react_1.default.createElement(_1.CardActionButton, { label: "All Business Headlines", trailingIcon: "arrow_forward" })))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Mini Card Example"),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Card, { style: { width: '12.5rem' } },
                react_1.default.createElement(_1.CardPrimaryAction, null,
                    react_1.default.createElement(_1.CardMedia, { square: true, style: {
                            backgroundImage: 'url(images/backgrounds/mb-bg-fb-06.png)'
                        } },
                        react_1.default.createElement(_1.CardMediaContent, null,
                            react_1.default.createElement(typography_1.Typography, { use: "subtitle2", tag: "div", theme: "textPrimaryOnDark", style: {
                                    padding: '0.5rem 1rem',
                                    backgroundImage: 'linear-gradient(to bottom, transparent 0%, rgba(0, 0, 0, 0.5) 100%)',
                                    bottom: '0',
                                    left: '0',
                                    right: '0',
                                    position: 'absolute'
                                } }, "Vacation Photos")))),
                react_1.default.createElement(_1.CardActions, null,
                    react_1.default.createElement(_1.CardActionIcons, null,
                        react_1.default.createElement(_1.CardActionIcon, { onIcon: "favorite", icon: "favorite_border" }),
                        react_1.default.createElement(_1.CardActionIcon, { icon: "bookmark_border" }),
                        react_1.default.createElement(_1.CardActionIcon, { icon: "share" }))))),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'Card', component: _1.Card },
                { displayName: 'CardPrimaryAction', component: _1.CardPrimaryAction },
                { displayName: 'CardMedia', component: _1.CardMedia },
                { displayName: 'CardMediaContent', component: _1.CardMediaContent },
                { displayName: 'CardActions', component: _1.CardActions },
                { displayName: 'CardActionButtons', component: _1.CardActionButtons },
                { displayName: 'CardActionIcons', component: _1.CardActionIcons },
                { displayName: 'CardActionIcon', component: _1.CardActionIcon },
                { displayName: 'CardActionButton', component: _1.CardActionButton }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(_1.Card, { style: { width: '12.5rem', transform: 'scale(0.5)' } },
    react_1.default.createElement(_1.CardPrimaryAction, null,
        react_1.default.createElement(_1.CardMedia, { square: true, style: {
                backgroundImage: 'url(images/backgrounds/mb-bg-fb-06.png)'
            } },
            react_1.default.createElement(_1.CardMediaContent, null,
                react_1.default.createElement(typography_1.Typography, { use: "subtitle2", tag: "div", theme: "textPrimaryOnDark", style: {
                        padding: '0.5rem 1rem',
                        backgroundImage: 'linear-gradient(to bottom, transparent 0%, rgba(0, 0, 0, 0.5) 100%)',
                        bottom: '0',
                        left: '0',
                        right: '0',
                        position: 'absolute'
                    } }, "Vacation Photos")))),
    react_1.default.createElement(_1.CardActions, null,
        react_1.default.createElement(_1.CardActionIcons, null,
            react_1.default.createElement(_1.CardActionIcon, { onIcon: "favorite", icon: "favorite_border" }),
            react_1.default.createElement(_1.CardActionIcon, { icon: "bookmark_border" }),
            react_1.default.createElement(_1.CardActionIcon, { icon: "share" })))));
