"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useChipFoundation = void 0;
var tslib_1 = require("tslib");
var base_1 = require("@rmwc/base");
var base_2 = require("@rmwc/base");
var chips_1 = require("@material/chips");
var react_1 = require("react");
var useChipFoundation = function (props) {
    var chipId = base_1.useId('chip', props);
    var trailingAction = react_1.useRef();
    var setTrailingAction = function (api) {
        trailingAction.current = api;
    };
    var foundationWithElements = base_2.useFoundation({
        props: props,
        elements: {
            rootEl: true,
            trailingIconEl: true,
            checkmarkEl: true,
            trailingActionEl: true
        },
        foundation: function (_a) {
            var rootEl = _a.rootEl, checkmarkEl = _a.checkmarkEl, emit = _a.emit, getProps = _a.getProps, trailingActionEl = _a.trailingActionEl;
            return new chips_1.MDCChipFoundation({
                addClass: function (className) {
                    rootEl.addClass(className);
                },
                removeClass: function (className) { return rootEl.removeClass(className); },
                hasClass: function (className) { return rootEl.hasClass(className); },
                addClassToLeadingIcon: function (className) {
                    // handled by props
                },
                removeClassFromLeadingIcon: function (className) {
                    // handled by props
                },
                eventTargetHasClass: function (target, className) {
                    return (rootEl.hasClass(className) || target.classList.contains(className));
                },
                notifyInteraction: function () {
                    return emit('onInteraction', { chipId: chipId }, true /* shouldBubble */);
                },
                notifySelection: function (selected) {
                    return emit('onSelect', { chipId: chipId, selected: selected }, true /* shouldBubble */);
                },
                notifyTrailingIconInteraction: function () {
                    return emit('onTrailingIconInteraction', { chipId: chipId }, true /* shouldBubble */);
                },
                notifyRemoval: function () {
                    return emit('onRemove', { chipId: chipId, root: rootEl.ref }, true /* shouldBubble */);
                },
                notifyNavigation: function (key, source) {
                    //TODO, but probably not needed in case of React
                },
                getComputedStyleValue: function (propertyName) {
                    return rootEl.ref
                        ? window.getComputedStyle(rootEl.ref).getPropertyValue(propertyName)
                        : '';
                },
                setStyleProperty: function (propertyName, value) {
                    rootEl.setStyle(propertyName, value);
                },
                getAttribute: function (attrName) { var _a; return (_a = rootEl.ref) === null || _a === void 0 ? void 0 : _a.getAttribute(attrName); },
                hasLeadingIcon: function () { return !!props.icon; },
                getRootBoundingClientRect: function () { var _a; return ((_a = rootEl.ref) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect()) || base_1.emptyClientRect; },
                getCheckmarkBoundingClientRect: function () { var _a; return ((_a = checkmarkEl.ref) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect()) || base_1.emptyClientRect; },
                setPrimaryActionAttr: function (attr, value) {
                    // Not clear in documentation what this should be used for
                },
                focusPrimaryAction: function () {
                    // Not clear in documentation what this should be used for
                },
                setTrailingActionAttr: function (attr, value) {
                    var safeAttr = attr === 'tabindex' ? 'tabIndex' : attr;
                    return trailingActionEl.setProp(safeAttr, value);
                },
                focusTrailingAction: function () {
                    var _a;
                    return (_a = trailingActionEl.ref) === null || _a === void 0 ? void 0 : _a.focus();
                },
                removeTrailingActionFocus: function () {
                    var _a;
                    return (_a = trailingAction.current) === null || _a === void 0 ? void 0 : _a.getFoundation().removeFocus();
                },
                isTrailingActionNavigable: function () {
                    var _a;
                    return (_a = trailingAction.current) === null || _a === void 0 ? void 0 : _a.getFoundation().isNavigable();
                },
                isRTL: function () {
                    return rootEl.ref
                        ? window
                            .getComputedStyle(rootEl.ref)
                            .getPropertyValue('direction') === 'rtl'
                        : false;
                },
                notifyEditFinish: function () {
                    // NOT IMPLEMENTED IN MATERIAL 7
                },
                notifyEditStart: function () {
                    // NOT IMPLEMENTED IN MATERIAL 7
                }
            });
        }
    });
    var rootEl = foundationWithElements.rootEl, trailingIconEl = foundationWithElements.trailingIconEl, foundation = foundationWithElements.foundation;
    var onClick = props.onClick, onKeyDown = props.onKeyDown;
    var handleInteraction = react_1.useCallback(function (evt) {
        evt.type === 'click' && (onClick === null || onClick === void 0 ? void 0 : onClick(evt));
        evt.type === 'keydown' && (onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(evt));
        return foundation.handleClick();
    }, [foundation, onClick, onKeyDown]);
    var handleTransitionEnd = react_1.useCallback(function (evt) {
        foundation.handleTransitionEnd(evt);
    }, [foundation]);
    var handleTrailingActionInteraction = react_1.useCallback(function () {
        return foundation.handleTrailingActionInteraction();
    }, [foundation]);
    // Allow customizing the behavior of the trailing icon
    react_1.useEffect(function () {
        var _a;
        foundation.setShouldRemoveOnTrailingIconClick((_a = props.trailingIconRemovesChip) !== null && _a !== void 0 ? _a : true);
    }, [foundation, props.trailingIconRemovesChip]);
    rootEl.setProp('onClick', handleInteraction, true);
    rootEl.setProp('onKeyDown', handleInteraction, true);
    rootEl.setProp('onTransitionEnd', handleTransitionEnd, true);
    trailingIconEl.setProp('onClick', handleTrailingActionInteraction, true);
    trailingIconEl.setProp('onKeyDown', handleTrailingActionInteraction, true);
    return tslib_1.__assign({ setTrailingAction: setTrailingAction }, foundationWithElements);
};
exports.useChipFoundation = useChipFoundation;
