"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChipSet = exports.Chip = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var ripple_1 = require("@rmwc/ripple");
var icon_1 = require("@rmwc/icon");
var foundation_1 = require("./foundation");
var base_1 = require("@rmwc/base");
/** A Chip component. */
exports.Chip = ripple_1.withRipple()(base_1.createComponent(function Chip(props, ref) {
    var onInteraction = props.onInteraction, onTrailingIconInteraction = props.onTrailingIconInteraction, onRemove = props.onRemove, onSelect = props.onSelect, icon = props.icon, trailingIcon = props.trailingIcon, trailingIconRemovesChip = props.trailingIconRemovesChip, checkmark = props.checkmark, label = props.label, children = props.children, selected = props.selected, foundationRef = props.foundationRef, rest = tslib_1.__rest(props, ["onInteraction", "onTrailingIconInteraction", "onRemove", "onSelect", "icon", "trailingIcon", "trailingIconRemovesChip", "checkmark", "label", "children", "selected", "foundationRef"]);
    var _a = foundation_1.useChipFoundation(props), rootEl = _a.rootEl, checkmarkEl = _a.checkmarkEl, trailingIconEl = _a.trailingIconEl;
    var className = base_1.useClassNames(props, [
        'mdc-chip',
        {
            'mdc-chip--selected': selected
        }
    ]);
    return (react_1.default.createElement(base_1.Tag, tslib_1.__assign({ role: "row" }, rest, { element: rootEl, className: className, ref: ref }),
        react_1.default.createElement(ChipRipple, null),
        !!icon && (react_1.default.createElement(ChipIcon, { icon: icon, leading: true, hidden: selected && checkmark })),
        !!checkmark && react_1.default.createElement(ChipCheckmark, { ref: checkmarkEl.setRef }),
        react_1.default.createElement("span", { role: "gridcell" },
            react_1.default.createElement("span", { role: "button", className: "mdc-chip__text__primary-action", tabIndex: 0 },
                react_1.default.createElement("span", { className: "mdc-chip__text" },
                    label,
                    children))),
        !!trailingIcon && (react_1.default.createElement(ChipIcon, tslib_1.__assign({ icon: trailingIcon, trailing: true }, trailingIconEl.props({}))))));
}));
/*********************************************************************
 * Bits
 *********************************************************************/
var ChipRipple = react_1.default.memo(function ChipRipple() {
    return react_1.default.createElement("div", { className: "mdc-chip__ripple" });
});
/** A checkmark for chip selection and filtering. */
var ChipCheckmark = react_1.default.memo(react_1.default.forwardRef(function ChipCheckmark(props, ref) {
    return (react_1.default.createElement("div", { ref: ref, className: "mdc-chip__checkmark" },
        react_1.default.createElement("svg", { className: "mdc-chip__checkmark-svg", viewBox: "-2 -3 30 30" },
            react_1.default.createElement("path", { className: "mdc-chip__checkmark-path", fill: "none", stroke: "black", d: "M1.73,12.91 8.1,19.28 22.79,4.59" }))));
}));
/** Icons inside of a chip. This is an instance of the Icon component. To make the icons interactive, add props tabIndex="0" and role="button". */
var ChipIcon = react_1.default.memo(function ChipIcon(props) {
    var leading = props.leading, trailing = props.trailing, hidden = props.hidden, rest = tslib_1.__rest(props, ["leading", "trailing", "hidden"]);
    var className = base_1.useClassNames(props, [
        'mdc-chip__icon',
        {
            'mdc-chip__icon--leading': leading,
            'mdc-chip__icon--leading-hidden': hidden,
            'mdc-chip__icon--trailing': trailing
        }
    ]);
    var hasInteractionHandler = Object.keys(props).some(function (p) {
        return p.startsWith('on');
    });
    var trailingProps = props.trailing || hasInteractionHandler
        ? { role: 'button', tabIndex: 0 }
        : {};
    return react_1.default.createElement(icon_1.Icon, tslib_1.__assign({}, trailingProps, rest, { className: className }));
});
/** A container for multiple chips. */
exports.ChipSet = base_1.createComponent(function ChipSet(props, ref) {
    var choice = props.choice, filter = props.filter, rest = tslib_1.__rest(props, ["choice", "filter"]);
    var className = base_1.useClassNames(props, [
        'mdc-chip-set',
        {
            'mdc-chip-set--choice': choice,
            'mdc-chip-set--filter': filter
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, className: className }));
});
