"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Chips", lead: "Chips represent complex entities in small blocks, such as a contact.", module: "@rmwc/chip", styles: [
            '@material/chips/dist/mdc.chips.css',
            '@rmwc/icon/icon.css',
            '@material/ripple/dist/mdc.ripple.css'
        ], docsLink: "https://material.io/develop/web/components/chips/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Default" },
            react_1.default.createElement(_1.ChipSet, null,
                react_1.default.createElement(_1.Chip, { selected: true, label: "Cookies" }),
                react_1.default.createElement(_1.Chip, { label: "Pizza" }),
                react_1.default.createElement(_1.Chip, { label: "Icecream" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "With Icons" },
            react_1.default.createElement(_1.ChipSet, null,
                react_1.default.createElement(_1.Chip, { icon: "favorite", label: "Cookies", trailingIcon: "close" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Event Handling" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState(false), 2), selected = _a[0], setSelected = _a[1];
            return (react_1.default.createElement(_1.ChipSet, null,
                react_1.default.createElement(_1.Chip, { key: "my-chip", label: "Click Me", checkmark: true, selected: selected, onRemove: function (evt) { return console.log('onRemove', evt.detail); }, onInteraction: function (evt) {
                        console.log('onInteraction', evt.detail);
                        setSelected(!selected);
                    }, onTrailingIconInteraction: function (evt) {
                        return console.log('onTrailingIconIteraction', evt.detail);
                    }, trailingIcon: "close" })));
        }),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Filter and Choice Chipsets"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "You can specify a `ChipSet` as either a `filter` of `choice` which slightly changes the visual styling of selected chips. While `material-components-web` has some built in functionality for chip sets, it doesn't fit well with React's unidirectional data flow. It is recommended you use standard React patterns to store selected chips in your state and render them accordingly."),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Clicking on the trailing close icon will trigger a close animation and put the chip in an exited state, but it is up to you to remove component out from rendering. The you use the `onRemove` prop implement this behavior."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Filter" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState({
                cookies: false,
                pizza: false,
                icecream: false
            }), 2), selected = _a[0], setSelected = _a[1];
            //@ts-ignore
            var toggleSelected = function (key) {
                var _a;
                return setSelected(tslib_1.__assign(tslib_1.__assign({}, selected), (_a = {}, _a[key] = !selected[key], _a)));
            };
            return (react_1.default.createElement(_1.ChipSet, { filter: true },
                react_1.default.createElement(_1.Chip, { selected: selected.cookies, checkmark: true, onInteraction: function () { return toggleSelected('cookies'); }, label: "Cookies" }),
                react_1.default.createElement(_1.Chip, { selected: selected.pizza, checkmark: true, onInteraction: function () { return toggleSelected('pizza'); }, icon: "local_pizza", label: "Pizza" }),
                react_1.default.createElement(_1.Chip, { selected: selected.icecream, checkmark: true, onInteraction: function () { return toggleSelected('icecream'); }, icon: "favorite_border", label: "Icecream" })));
        }),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Choice" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState({
                cookies: false,
                pizza: false,
                icecream: false
            }), 2), selected = _a[0], setSelected = _a[1];
            //@ts-ignore
            var toggleSelected = function (key) {
                var _a;
                return setSelected(tslib_1.__assign(tslib_1.__assign({}, selected), (_a = {}, _a[key] = !selected[key], _a)));
            };
            return (react_1.default.createElement(_1.ChipSet, { choice: true },
                react_1.default.createElement(_1.Chip, { selected: selected.cookies, onInteraction: function () { return toggleSelected('cookies'); }, label: "Cookies" }),
                react_1.default.createElement(_1.Chip, { selected: selected.pizza, onInteraction: function () { return toggleSelected('pizza'); }, icon: "local_pizza", label: "Pizza" }),
                react_1.default.createElement(_1.Chip, { selected: selected.icecream, onInteraction: function () { return toggleSelected('icecream'); }, icon: "favorite_border", label: "Icecream" })));
        }),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'Chip', component: _1.Chip },
                { displayName: 'ChipSet', component: _1.ChipSet }
            ] })));
}
exports.default = Readme;
exports.galleryExample = react_1.default.createElement(_1.Chip, { selected: true, checkmark: true, label: "Cookies" });
