"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTrailingActionFoundation = void 0;
var base_1 = require("@rmwc/base");
var chips_1 = require("@material/chips");
var useTrailingActionFoundation = function (props) {
    var foundationWithElements = base_1.useFoundation({
        props: props,
        elements: { rootEl: true },
        foundation: function (_a) {
            var rootEl = _a.rootEl, emit = _a.emit;
            return new chips_1.MDCChipTrailingActionFoundation({
                focus: function () { var _a; return (_a = rootEl.ref) === null || _a === void 0 ? void 0 : _a.focus(); },
                getAttribute: function (attr) {
                    return rootEl.ref && rootEl.ref.getAttribute(attr);
                },
                notifyInteraction: function (trigger) {
                    emit('onInteraction', { trigger: trigger });
                },
                notifyNavigation: function (key) {
                    emit('onNavigation', { key: key });
                },
                setAttribute: function (attr, value) {
                    return rootEl.setProp(attr, value);
                }
            });
        }
    });
    return foundationWithElements;
};
exports.useTrailingActionFoundation = useTrailingActionFoundation;
