"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrailingAction = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var base_1 = require("@rmwc/base");
/** The trailing action is used in removable input chips.
 * It is a subcomponent of the chips and intended only for use in the context of a chip. */
exports.TrailingAction = base_1.createComponent(function TrailingAction(props, ref) {
    return (react_1.default.createElement(base_1.Tag, { tag: "buton", className: "mdc-chip-trailing-action", "aria-hidden": props.isNavigable, ref: ref },
        react_1.default.createElement("span", { className: "mdc-chip-trailing-action__ripple" }),
        react_1.default.createElement("span", { className: "mdc-chip-trailing-action__icon material-icons" }, props.icon)));
});
