import React from 'react';
import { createComponent, Tag } from '@rmwc/base';
/** The trailing action is used in removable input chips.
 * It is a subcomponent of the chips and intended only for use in the context of a chip. */
export var TrailingAction = createComponent(function TrailingAction(props, ref) {
    return (React.createElement(Tag, { tag: "buton", className: "mdc-chip-trailing-action", "aria-hidden": props.isNavigable, ref: ref },
        React.createElement("span", { className: "mdc-chip-trailing-action__ripple" }),
        React.createElement("span", { className: "mdc-chip-trailing-action__icon material-icons" }, props.icon)));
});
