"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useFloatingLabelFoundation = void 0;
var tslib_1 = require("tslib");
var base_1 = require("@rmwc/base");
var floating_label_1 = require("@material/floating-label");
var react_1 = require("react");
var useFloatingLabelFoundation = function (props) {
    var _a = base_1.useFoundation({
        props: props,
        elements: {
            rootEl: true
        },
        api: function (_a) {
            var foundation = _a.foundation;
            return {
                getWidth: function () {
                    return foundation.getWidth();
                },
                setRequired: function (isRequired) {
                    return foundation.setRequired(isRequired);
                }
            };
        },
        foundation: function (_a) {
            var rootEl = _a.rootEl;
            return new floating_label_1.MDCFloatingLabelFoundation({
                addClass: function (className) { return rootEl.addClass(className); },
                removeClass: function (className) { return rootEl.removeClass(className); },
                getWidth: function () { var _a; return ((_a = rootEl.ref) === null || _a === void 0 ? void 0 : _a.scrollWidth) || 0; },
                registerInteractionHandler: function (evtType, handler) { return rootEl.addEventListener(evtType, handler); },
                deregisterInteractionHandler: function (evtType, handler) { return rootEl.removeEventListener(evtType, handler); }
            });
        }
    }), foundation = _a.foundation, elements = tslib_1.__rest(_a, ["foundation"]);
    // Shake
    react_1.useEffect(function () {
        foundation.shake(!!props.shake);
    }, [props.shake, foundation]);
    // Float
    react_1.useEffect(function () {
        foundation.float(!!props.float);
    }, [props.float, foundation]);
    return tslib_1.__assign({ foundation: foundation }, elements);
};
exports.useFloatingLabelFoundation = useFloatingLabelFoundation;
