"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormField = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var base_1 = require("@rmwc/base");
var foundation_1 = require("./foundation");
/** A FormField component. */
exports.FormField = base_1.createComponent(function FormField(props, ref) {
    foundation_1.useFormfieldFoundation(props);
    var alignEnd = props.alignEnd, foundationRef = props.foundationRef, rest = tslib_1.__rest(props, ["alignEnd", "foundationRef"]);
    var className = base_1.useClassNames(props, [
        'mdc-form-field',
        {
            'mdc-form-field--align-end': props.alignEnd
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, className: className }));
});
