"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GridTileTitleSupportText = exports.GridTileTitle = exports.GridTileIcon = exports.GridTileSecondary = exports.GridTile = exports.GridTilePrimaryContent = exports.GridTilePrimary = exports.GridList = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var icon_1 = require("@rmwc/icon");
var base_1 = require("@rmwc/base");
/** Grid List Component */
exports.GridList = base_1.createComponent(function GridList(props, ref) {
    var _a;
    var tileGutter1 = props.tileGutter1, headerCaption = props.headerCaption, twolineCaption = props.twolineCaption, withIconAlignStart = props.withIconAlignStart, _b = props.tileAspect, tileAspect = _b === void 0 ? '1x1' : _b, children = props.children, rest = tslib_1.__rest(props, ["tileGutter1", "headerCaption", "twolineCaption", "withIconAlignStart", "tileAspect", "children"]);
    var className = base_1.useClassNames(props, [
        'mdc-grid-list',
        (_a = {
                'mdc-grid-list--tile-gutter-1': tileGutter1,
                'mdc-grid-list--header-caption': headerCaption,
                'mdc-grid-list--twoline-caption': twolineCaption,
                'mdc-grid-list--with-icon-align-start': withIconAlignStart
            },
            _a["mdc-grid-list--tile-aspect-" + (tileAspect || '')] = tileAspect,
            _a)
    ]);
    return (react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, className: className }),
        react_1.default.createElement("ul", { className: "mdc-grid-list__tiles" }, children)));
});
/** The primary content for a Grid tile */
exports.GridTilePrimary = base_1.createComponent(function GridTilePrimary(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile__primary']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** The inner primary content for a Grid tile */
exports.GridTilePrimaryContent = base_1.createComponent(function GridTilePrimaryContent(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile__primary-content']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "img" }, props, { ref: ref, className: className }));
});
/** A grid tile */
exports.GridTile = base_1.createComponent(function GridTile(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "li" }, props, { ref: ref, className: className }));
});
/** The secondary content for a Grid tile */
exports.GridTileSecondary = base_1.createComponent(function GridTileSecondary(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile__secondary']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "span" }, props, { ref: ref, className: className }));
});
/** The icon for a Grid tile. This is an instance of Icon component. */
exports.GridTileIcon = base_1.createMemoComponent(function GridTileIcon(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile__icon']);
    return react_1.default.createElement(icon_1.Icon, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** The title for a Grid tile */
exports.GridTileTitle = base_1.createComponent(function GridTileTitle(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile__title']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "span" }, props, { ref: ref, className: className }));
});
/** Supporting Text for the Grid Tile */
exports.GridTileTitleSupportText = base_1.createComponent(function GridTileTitleSupportText(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-grid-tile__support-text']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "span" }, props, { ref: ref, className: className }));
});
