"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
var checkbox_1 = require("../checkbox");
var select_1 = require("../select");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Grid Lists", lead: "Grid lists are an alternative to standard list views. Note that as of Material Components Web 6.0.0, this component is deprecated.", module: "@rmwc/grid-list", styles: ['@material/grid-list/dist/mdc.grid-list.css'], docsLink: "https://material.io/components/web/catalog/grid-lists/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsExample, null, function Example() {
            var _a = tslib_1.__read(react_1.default.useState({
                tileGutter1: false,
                headerCaption: false,
                twolineCaption: false,
                withIconAlignStart: false,
                tileAspect: '1x1'
            }), 2), state = _a[0], setState = _a[1];
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.GridList, { tileGutter1: state.tileGutter1, headerCaption: state.headerCaption, twolineCaption: state.twolineCaption, withIconAlignStart: state.withIconAlignStart, 
                    // @ts-ignore
                    tileAspect: state.tileAspect }, Array(8)
                    .fill(undefined)
                    .map(function (val, i) { return (react_1.default.createElement(_1.GridTile, { key: i },
                    react_1.default.createElement(_1.GridTilePrimary, null,
                        react_1.default.createElement(_1.GridTilePrimaryContent, { src: "images/backgrounds/mb-bg-fb-06.png", alt: "test" })),
                    react_1.default.createElement(_1.GridTileSecondary, null,
                        react_1.default.createElement(_1.GridTileIcon, { icon: "info" }),
                        react_1.default.createElement(_1.GridTileTitle, null,
                            "Tile ",
                            i + 1)))); })),
                [
                    'tileGutter1',
                    'headerCaption',
                    'twoLineCaption',
                    'withIconAlignStart'
                ].map(function (key) { return (react_1.default.createElement(checkbox_1.Checkbox, { key: key, label: key, onChange: function (evt) {
                        var _a;
                        return setState(tslib_1.__assign(tslib_1.__assign({}, state), (_a = {}, _a[key] = evt.currentTarget.checked, _a)));
                    } })); }),
                react_1.default.createElement(select_1.Select, { value: state.tileAspect, onChange: function (evt) {
                        return setState(tslib_1.__assign(tslib_1.__assign({}, state), { tileAspect: String(evt.currentTarget.value) }));
                    }, label: "tileAspect", options: ['1x1', '16x9', '2x3', '3x2', '4x3', '3x4'] })));
        }),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'GridList', component: _1.GridList },
                { displayName: 'GridTile', component: _1.GridTile },
                { displayName: 'GridTileIcon', component: _1.GridTileIcon },
                { displayName: 'GridTilePrimary', component: _1.GridTilePrimary },
                { displayName: 'GridTileSecondary', component: _1.GridTileSecondary },
                {
                    displayName: 'GridTileTitleSupportText',
                    component: _1.GridTileTitleSupportText
                },
                { displayName: 'GridTileTitle', component: _1.GridTileTitle }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(_1.GridList, { tileGutter1: true, style: { transform: 'scale(0.5)' } }, Array(4)
    .fill(undefined)
    .map(function (val, i) { return (react_1.default.createElement(_1.GridTile, { key: i, style: { maxWidth: '100px' } },
    react_1.default.createElement(_1.GridTilePrimary, null,
        react_1.default.createElement(_1.GridTilePrimaryContent, { src: "images/backgrounds/mb-bg-fb-06.png", alt: "test" })),
    react_1.default.createElement(_1.GridTileSecondary, null,
        react_1.default.createElement(_1.GridTileIcon, { icon: "info" }),
        react_1.default.createElement(_1.GridTileTitle, null,
            "Tile ",
            i + 1)))); })));
