"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useLineRippleFoundation = void 0;
var tslib_1 = require("tslib");
var react_1 = require("react");
var base_1 = require("@rmwc/base");
var line_ripple_1 = require("@material/line-ripple");
var useLineRippleFoundation = function (props) {
    var _a = base_1.useFoundation({
        props: props,
        elements: {
            rootEl: true
        },
        foundation: function (_a) {
            var rootEl = _a.rootEl;
            return new line_ripple_1.MDCLineRippleFoundation({
                addClass: function (className) { return rootEl.addClass(className); },
                removeClass: function (className) { return rootEl.removeClass(className); },
                hasClass: function (className) { return rootEl.hasClass(className); },
                setStyle: function (propertyName, value) {
                    return rootEl.setStyle(propertyName, value);
                },
                registerEventHandler: function (evtType, handler) { return rootEl.addEventListener(evtType, handler); },
                deregisterEventHandler: function (evtType, handler) { return rootEl.removeEventListener(evtType, handler); }
            });
        }
    }), foundation = _a.foundation, elements = tslib_1.__rest(_a, ["foundation"]);
    var rootEl = elements.rootEl;
    // Active
    react_1.useEffect(function () {
        props.active ? foundation.activate() : foundation.deactivate();
    }, [props.active, foundation]);
    // Center
    react_1.useEffect(function () {
        typeof props.center === 'number' &&
            foundation.setRippleCenter(props.center);
    }, [props.center, foundation]);
    // Transition end
    rootEl.setProp('onTransitionEnd', function (evt) { return foundation.handleTransitionEnd(evt); }, true);
    return tslib_1.__assign({ foundation: foundation }, elements);
};
exports.useLineRippleFoundation = useLineRippleFoundation;
