"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleListItem = exports.ListDivider = exports.ListGroupSubheader = exports.ListGroup = exports.ListItemMeta = exports.ListItemGraphic = exports.ListItemSecondaryText = exports.ListItemPrimaryText = exports.ListItemText = exports.ListItem = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var base_1 = require("@rmwc/base");
var ripple_1 = require("@rmwc/ripple");
var icon_1 = require("@rmwc/icon");
/** A ListItem component. */
exports.ListItem = ripple_1.withRipple({ surface: false })(base_1.createComponent(function ListItem(props, ref) {
    var selected = props.selected, activated = props.activated, disabled = props.disabled, rest = tslib_1.__rest(props, ["selected", "activated", "disabled"]);
    var className = base_1.useClassNames(props, [
        'mdc-list-item',
        {
            'mdc-list-item--selected': props.selected,
            'mdc-list-item--activated': props.activated,
            'mdc-list-item--disabled': props.disabled
        }
    ]);
    return (react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "li", tabIndex: 0 }, rest, { className: className, ref: ref }),
        react_1.default.createElement(ripple_1.RippleSurface, { className: "mdc-list-item__ripple" }),
        rest.children));
}));
/** Text Wrapper for the ListItem */
exports.ListItemText = base_1.createComponent(function ListItemText(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-item__text']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "span" }, props, { ref: ref, className: className }));
});
/** Primary Text for the ListItem */
exports.ListItemPrimaryText = base_1.createComponent(function ListItemPrimaryText(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-item__primary-text']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "span" }, props, { ref: ref, className: className }));
});
/** Secondary text for the ListItem */
exports.ListItemSecondaryText = base_1.createComponent(function ListItemSecondaryText(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-item__secondary-text']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "span" }, props, { ref: ref, className: className }));
});
/** A graphic / icon for the ListItem */
exports.ListItemGraphic = base_1.createComponent(function ListItemGraphic(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-item__graphic']);
    return (react_1.default.createElement(icon_1.Icon, tslib_1.__assign({}, props, { "aria-hidden": "true", ref: ref, className: className })));
});
/** Meta content for the ListItem. This can either by an icon by setting the `icon` prop, or any other kind of content. */
exports.ListItemMeta = base_1.createComponent(function ListItemMeta(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-item__meta']);
    if (!!props.icon) {
        return (react_1.default.createElement(icon_1.Icon, tslib_1.__assign({}, props, { "aria-hidden": "true", ref: ref, className: className })));
    }
    if (react_1.default.isValidElement(props.children)) {
        var children = props.children, rest = tslib_1.__rest(props, ["children"]);
        return react_1.default.cloneElement(props.children, tslib_1.__assign(tslib_1.__assign(tslib_1.__assign({}, rest), props.children.props), { className: base_1.classNames(className, props.children.props.className) }));
    }
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A container to group ListItems */
exports.ListGroup = base_1.createComponent(function ListGroup(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-group']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A subheader for the ListGroup */
exports.ListGroupSubheader = base_1.createComponent(function ListGroupSubheader(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-group__subheader']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A divider for the List */
exports.ListDivider = base_1.createComponent(function ListDivider(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-list-divider']);
    return (react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "li", role: "separator" }, props, { ref: ref, className: className })));
});
/** A simple list item template. */
exports.SimpleListItem = base_1.createComponent(function (_a, ref) {
    var text = _a.text, secondaryText = _a.secondaryText, graphic = _a.graphic, metaIcon = _a.metaIcon, meta = _a.meta, children = _a.children, rest = tslib_1.__rest(_a, ["text", "secondaryText", "graphic", "metaIcon", "meta", "children"]);
    var primaryTextToRender = text && secondaryText !== undefined ? (react_1.default.createElement(exports.ListItemPrimaryText, null, text)) : (text);
    var secondaryTextToRender = secondaryText !== undefined ? (react_1.default.createElement(exports.ListItemSecondaryText, null, secondaryText)) : null;
    return (react_1.default.createElement(exports.ListItem, tslib_1.__assign({}, rest, { ref: ref }),
        react_1.default.createElement(ripple_1.RippleSurface, { className: "mdc-list-item__ripple" }),
        graphic !== undefined && react_1.default.createElement(exports.ListItemGraphic, { icon: graphic }),
        secondaryTextToRender !== null ? (react_1.default.createElement(exports.ListItemText, null,
            primaryTextToRender,
            secondaryTextToRender)) : (primaryTextToRender),
        (!!meta || !!metaIcon) && (react_1.default.createElement(exports.ListItemMeta, { icon: metaIcon }, meta)),
        children));
});
