"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_collapsible_json_1 = tslib_1.__importDefault(require("./generated-examples-collapsible.json"));
var _1 = require(".");
var rmwc_1 = require("../rmwc");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Collapsible Lists", lead: "Lists are continuous, vertical indexes of text or images.", module: "@rmwc/list", styles: [
            '@material/list/dist/mdc.list.css',
            '@rmwc/list/collapsible-list.css'
        ], examples: generated_examples_collapsible_json_1.default, addon: true },
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Collapsible lists aren't part of the material spec, but they've been added to RMWC after continuing requests from the community. They present an accordion style navigation element to progressively reveal content. They've have been built to work with the `List` and `ListItem` components in regards to keyboard events and styling, but they technically be used with any kind of content."),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.List, null,
                react_1.default.createElement(rmwc_1.CollapsibleList, { handle: react_1.default.createElement(_1.SimpleListItem, { text: "Cookies", graphic: "favorite", metaIcon: "chevron_right" }), onOpen: function () { return console.log('open'); }, onClose: function () { return console.log('close'); } },
                    react_1.default.createElement(_1.SimpleListItem, { text: "Chocolate Chip" }),
                    react_1.default.createElement(_1.SimpleListItem, { text: "Ginger Snap" }),
                    react_1.default.createElement(_1.SimpleListItem, { text: "Peanut Butter" })),
                react_1.default.createElement(rmwc_1.CollapsibleList, { handle: react_1.default.createElement(_1.SimpleListItem, { text: "Pizza", graphic: "local_pizza", metaIcon: "chevron_right" }) },
                    react_1.default.createElement(_1.SimpleListItem, { text: "Cheese" }),
                    react_1.default.createElement(_1.SimpleListItem, { text: "Pepperoni" }),
                    react_1.default.createElement(_1.SimpleListItem, { text: "Supreme" })),
                react_1.default.createElement(rmwc_1.CollapsibleList, { handle: react_1.default.createElement(_1.SimpleListItem, { text: "Icecream", graphic: "star", metaIcon: "chevron_right" }) },
                    react_1.default.createElement(_1.SimpleListItem, { text: "Vanilla" }),
                    react_1.default.createElement(_1.SimpleListItem, { text: "Chocolate" }),
                    react_1.default.createElement(rmwc_1.CollapsibleList, { handle: react_1.default.createElement(_1.SimpleListItem, { text: "Nested Collapsible", graphic: "touch_app", metaIcon: "chevron_right" }) },
                        react_1.default.createElement(_1.SimpleListItem, { text: "Orange" }),
                        react_1.default.createElement(_1.SimpleListItem, { text: "Strawberry" }),
                        react_1.default.createElement(_1.SimpleListItem, { text: "Blueberry" }))),
                react_1.default.createElement(rmwc_1.CollapsibleList, { open: true, handle: react_1.default.createElement(_1.SimpleListItem, { text: "Custom Content, forced open", graphic: "help", metaIcon: "chevron_right" }) },
                    react_1.default.createElement("div", { style: {
                            padding: '4rem',
                            background: 'green',
                            color: 'white'
                        } }, "Collapsibles can contain any content")))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Usage as Non-List"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "`CollapsibleList` is optimized to work with the `List` component but there is nothing stopping you from using any other kind of content."),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(rmwc_1.CollapsibleList, { handle: react_1.default.createElement(rmwc_1.IconButton, { icon: "favorite_outline", onIcon: "favorite" }), onOpen: function () { return console.log('open'); }, onClose: function () { return console.log('close'); } },
                react_1.default.createElement("div", { style: {
                        padding: '1rem',
                        background: 'red',
                        color: 'white',
                        display: 'inline-block'
                    } }, "Favorited!"))),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'CollapsibleList', component: rmwc_1.CollapsibleList }
            ] })));
}
exports.default = Readme;
