"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_variants_json_1 = tslib_1.__importDefault(require("./generated-examples-variants.json"));
var _1 = require(".");
var avatar_1 = require("../avatar");
var checkbox_1 = require("../checkbox");
var switch_1 = require("../switch");
var radio_1 = require("../radio");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Lists", lead: "Lists are continuous, vertical indexes of text or images.", module: "@rmwc/list", styles: ['@material/list/dist/mdc.list.css'], docsLink: "https://material.io/develop/web/components/lists/", examples: generated_examples_variants_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Two Line"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "When using the `twoLine` prop, you have to wrap the contents of the `ListItem` in `ListItemText`."),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.List, { twoLine: true },
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemText, null,
                        react_1.default.createElement(_1.ListItemPrimaryText, null, "Cookies"),
                        react_1.default.createElement(_1.ListItemSecondaryText, null, "$4.99 a dozen"))),
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemText, null,
                        react_1.default.createElement(_1.ListItemPrimaryText, null, "Pizza"),
                        react_1.default.createElement(_1.ListItemSecondaryText, null, "$1.99 a slice"))),
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemText, null,
                        react_1.default.createElement(_1.ListItemPrimaryText, null, "Icecream"),
                        react_1.default.createElement(_1.ListItemSecondaryText, null, "$0.99 a scoop"))))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Leading and Trailing Icons"),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.List, null,
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemGraphic, { icon: "favorite" }),
                    "Leading"),
                react_1.default.createElement(_1.ListItem, null,
                    "Trailing",
                    react_1.default.createElement(_1.ListItemMeta, { icon: "star" })),
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemGraphic, { icon: "wifi" }),
                    "Leading and Trailing",
                    react_1.default.createElement(_1.ListItemMeta, { icon: "info" })),
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemGraphic, { icon: "wifi" }),
                    "Leading with Trailing Text",
                    react_1.default.createElement(_1.ListItemMeta, null, "HELLO!")))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Avatar List with Dividers"),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.List, { twoLine: true, avatarList: true },
                react_1.default.createElement(_1.ListGroup, null,
                    react_1.default.createElement(_1.ListItem, null,
                        react_1.default.createElement(_1.ListItemGraphic, { icon: react_1.default.createElement(avatar_1.Avatar, { src: "images/avatars/blackwidow.png", size: "xsmall", name: "Natalia Alianovna Romanova" }) }),
                        "Natalia Alianovna Romanova",
                        react_1.default.createElement(_1.ListItemMeta, { icon: "info" })),
                    react_1.default.createElement(_1.ListItem, null,
                        react_1.default.createElement(_1.ListItemGraphic, { icon: react_1.default.createElement(avatar_1.Avatar, { src: "images/avatars/hulk.png", size: "small", name: "Bruce Banner" }) }),
                        "Bruce Banner",
                        react_1.default.createElement(_1.ListItemMeta, { icon: "info" }))),
                react_1.default.createElement(_1.ListDivider, null),
                react_1.default.createElement(_1.ListGroup, null,
                    react_1.default.createElement(_1.ListItem, null,
                        react_1.default.createElement(_1.ListItemGraphic, { icon: react_1.default.createElement(avatar_1.Avatar, { src: "images/avatars/thor.png", size: "medium", name: "Thor Odinson" }) }),
                        "Thor Odinson",
                        react_1.default.createElement(_1.ListItemMeta, { icon: "info" }))))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Selectable"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Checkboxes and Radios can be included as part of `ListItemMeta`. It is recommended when using these that you are using controlled components, and that you put your interaction handler on the `ListItem` itself. Notice the `readOnly` prop is also set on the individual form elements."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Checkboxes" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState({
                Cookies: false,
                Pizza: false,
                Icecream: false
            }), 2), checked = _a[0], setChecked = _a[1];
            return (react_1.default.createElement(_1.List, null, ['Cookies', 'Pizza', 'Icecream'].map(function (key) { return (react_1.default.createElement(_1.ListItem, { key: key, onClick: function () {
                    var _a;
                    return setChecked(tslib_1.__assign(tslib_1.__assign({}, checked), (_a = {}, _a[key] = !checked[key], _a)));
                } },
                key,
                react_1.default.createElement(_1.ListItemMeta, null,
                    react_1.default.createElement(checkbox_1.Checkbox, { checked: checked[key], readOnly: true })))); })));
        }),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Switches" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState({
                Cookies: false,
                Pizza: false,
                Icecream: false
            }), 2), checked = _a[0], setChecked = _a[1];
            return (react_1.default.createElement(_1.List, null, ['Cookies', 'Pizza', 'Icecream'].map(function (key) { return (react_1.default.createElement(_1.ListItem, { key: key, onClick: function () {
                    var _a;
                    return setChecked(tslib_1.__assign(tslib_1.__assign({}, checked), (_a = {}, _a[key] = !checked[key], _a)));
                } },
                key,
                react_1.default.createElement(_1.ListItemMeta, null,
                    react_1.default.createElement(switch_1.Switch, { checked: checked[key], readOnly: true })))); })));
        }),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Radios" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState('Cookies'), 2), checked = _a[0], setChecked = _a[1];
            return (react_1.default.createElement(_1.List, null, ['Cookies', 'Pizza', 'Icecream'].map(function (key) { return (react_1.default.createElement(_1.ListItem, { key: key, onClick: function () { return setChecked(key); } },
                key,
                react_1.default.createElement(_1.ListItemMeta, null,
                    react_1.default.createElement(radio_1.Radio, { checked: checked === key, readOnly: true })))); })));
        }),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'List', component: _1.List },
                { displayName: 'ListItem', component: _1.ListItem },
                {
                    displayName: 'ListItemPrimaryText',
                    component: _1.ListItemPrimaryText
                },
                {
                    displayName: 'ListItemSecondaryText',
                    component: _1.ListItemSecondaryText
                },
                { displayName: 'ListItemGraphic', component: _1.ListItemGraphic },
                { displayName: 'ListItemMeta', component: _1.ListItemMeta },
                { displayName: 'ListDivider', component: _1.ListDivider },
                { displayName: 'ListGroup', component: _1.ListGroup },
                { displayName: 'ListGroupSubheader', component: _1.ListGroupSubheader },
                { displayName: 'SimpleListItem', component: _1.SimpleListItem }
            ] })));
}
exports.default = Readme;
