"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Lists", lead: "Lists are continuous, vertical indexes of text or images.", module: "@rmwc/list", styles: [
            '@material/list/dist/mdc.list.css',
            '@material/ripple/dist/mdc.ripple.css',
            '@rmwc/icon/icon.css'
        ], docsLink: "https://material.io/develop/web/components/lists/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Basic Usage"),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Default" },
            react_1.default.createElement(_1.List, null,
                react_1.default.createElement(_1.ListItem, null, "Cookies"),
                react_1.default.createElement(_1.ListItem, null, "Pizza"),
                react_1.default.createElement(_1.ListItem, null, "Icecream"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Fully Featured" },
            react_1.default.createElement(_1.List, { twoLine: true },
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemGraphic, { icon: "star_border" }),
                    react_1.default.createElement(_1.ListItemText, null,
                        react_1.default.createElement(_1.ListItemPrimaryText, null, "Cookies"),
                        react_1.default.createElement(_1.ListItemSecondaryText, null, "$4.99 a dozen")),
                    react_1.default.createElement(_1.ListItemMeta, { icon: "info" })),
                react_1.default.createElement(_1.ListItem, null,
                    react_1.default.createElement(_1.ListItemGraphic, { icon: "local_pizza" }),
                    react_1.default.createElement(_1.ListItemText, null,
                        react_1.default.createElement(_1.ListItemPrimaryText, null, "Pizza"),
                        react_1.default.createElement(_1.ListItemSecondaryText, null, "$1.99 a slice")),
                    react_1.default.createElement(_1.ListItemMeta, { icon: "info" })),
                react_1.default.createElement(_1.ListItem, { activated: true },
                    react_1.default.createElement(_1.ListItemGraphic, { icon: "mood" }),
                    react_1.default.createElement(_1.ListItemText, null,
                        react_1.default.createElement(_1.ListItemPrimaryText, null, "Icecream"),
                        react_1.default.createElement(_1.ListItemSecondaryText, null, "$0.99 a scoop")),
                    react_1.default.createElement(_1.ListItemMeta, null, "Winner!")))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Simplified Usage"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "While there are siutations where you would need / want to compose the entire list yourself, it can be quite verbose. `SimpleListItem` provides a compact syntax that allows you to pass all options as props. The following example is roughly equivalent to the one above."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Simple" },
            react_1.default.createElement(_1.List, { twoLine: true },
                react_1.default.createElement(_1.SimpleListItem, { graphic: "star_border", text: "Cookies", secondaryText: "Chocolate chip", metaIcon: "info" }),
                react_1.default.createElement(_1.SimpleListItem, { graphic: "local_pizza", text: "Pizza", secondaryText: "Pepperoni", metaIcon: "info" }),
                react_1.default.createElement(_1.SimpleListItem, { activated: true, graphic: "mood", text: "Icecream", secondaryText: "Chocolate cookie dough", meta: "Winner!" }))),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'List', component: _1.List },
                { displayName: 'ListItem', component: _1.ListItem },
                {
                    displayName: 'ListItemPrimaryText',
                    component: _1.ListItemPrimaryText
                },
                {
                    displayName: 'ListItemSecondaryText',
                    component: _1.ListItemSecondaryText
                },
                { displayName: 'ListItemGraphic', component: _1.ListItemGraphic },
                { displayName: 'ListItemMeta', component: _1.ListItemMeta },
                { displayName: 'ListDivider', component: _1.ListDivider },
                { displayName: 'ListGroup', component: _1.ListGroup },
                { displayName: 'ListGroupSubheader', component: _1.ListGroupSubheader },
                { displayName: 'SimpleListItem', component: _1.SimpleListItem }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(_1.List, { twoLine: true, style: { transform: 'scale(0.75)' } },
    react_1.default.createElement(_1.SimpleListItem, { graphic: "star_border", text: "Cookies", secondaryText: "Chocolate chip", metaIcon: "info" }),
    react_1.default.createElement(_1.SimpleListItem, { graphic: "local_pizza", text: "Pizza", secondaryText: "Pepperoni", metaIcon: "info" }),
    react_1.default.createElement(_1.SimpleListItem, { activated: true, graphic: "mood", text: "Icecream", secondaryText: "Chocolate cookie dough", meta: "Winner!" })));
