"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withRipple = exports.RippleSurface = exports.Ripple = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var ReactDOM = tslib_1.__importStar(require("react-dom"));
var base_1 = require("@rmwc/base");
var provider_1 = require("@rmwc/provider");
var foundation_1 = require("./foundation");
var RippleSurfaceContext = react_1.default.createContext({});
/** A component for adding Ripples to other components. */
var withDomNode = function () { return function (Component) {
    // @ts-ignore
    return /** @class */ (function (_super) {
        tslib_1.__extends(class_1, _super);
        function class_1() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.state = { domNode: null };
            return _this;
        }
        class_1.prototype.componentDidMount = function () {
            this.setState({ domNode: ReactDOM.findDOMNode(this) });
        };
        class_1.prototype.componentDidUpdate = function () {
            var rootRippleElement = ReactDOM.findDOMNode(this);
            if (rootRippleElement !== this.state.domNode) {
                this.setState({ rootRippleElement: rootRippleElement });
            }
        };
        class_1.prototype.render = function () {
            return react_1.default.createElement(Component, tslib_1.__assign({}, this.props, { domNode: this.state.domNode }));
        };
        return class_1;
    }(react_1.default.Component));
}; };
exports.Ripple = withDomNode()(function Ripple(props) {
    var children = props.children, className = props.className, primary = props.primary, accent = props.accent, unbounded = props.unbounded, surface = props.surface, domNode = props.domNode, foundationRef = props.foundationRef, rest = tslib_1.__rest(props, ["children", "className", "primary", "accent", "unbounded", "surface", "domNode", "foundationRef"]);
    var _a = foundation_1.useRippleFoundation(props), rootEl = _a.rootEl, surfaceEl = _a.surfaceEl;
    var child = react_1.default.Children.only(children);
    if (!react_1.default.isValidElement(child)) {
        return null;
    }
    // This flag really determines a lot
    // is surfaceIsRoot is true, then the surface props are spread
    // to the underlying component, otherwise the only place they
    // can be picked up is by the context consumer
    var surfaceIsRoot = !surface || !unbounded;
    var unboundedProp = unbounded
        ? { 'data-mdc-ripple-is-unbounded': true }
        : {};
    var rippleSurfaceProps = surfaceIsRoot
        ? surfaceEl.props({ style: child.props.style })
        : {};
    var finalClassNames = base_1.classNames(className !== child.props.className && className, rippleSurfaceProps.className, child.props.className, {
        'mdc-ripple-surface': typeof surface === 'boolean' ? surface : surface === undefined,
        'mdc-ripple-surface--primary': primary,
        'mdc-ripple-surface--accent': accent
    });
    // Fixes a ripple artifact issue
    // that is caused when clicking a button disables it
    // https://codesandbox.io/s/842vo56019
    if (rest.disabled) {
        finalClassNames = finalClassNames.replace('mdc-ripple-upgraded--background-focused', '');
    }
    // do some crazy props merging...
    var content = react_1.default.cloneElement(child, tslib_1.__assign(tslib_1.__assign(tslib_1.__assign({}, child.props), unboundedProp), rootEl.props(tslib_1.__assign(tslib_1.__assign(tslib_1.__assign(tslib_1.__assign({}, rest), { style: child.props.style }), rippleSurfaceProps), { className: finalClassNames }))));
    return (react_1.default.createElement(RippleSurfaceContext.Provider, { value: surfaceEl.props({ style: child.props.style }) }, content));
});
var RippleSurface = function (_a) {
    var className = _a.className, rest = tslib_1.__rest(_a, ["className"]);
    return (react_1.default.createElement(RippleSurfaceContext.Consumer, null, function (rippleSurfaceProps) { return (react_1.default.createElement("div", tslib_1.__assign({}, rest, rippleSurfaceProps, { className: className + " " + (rippleSurfaceProps.className || '') }))); }));
};
exports.RippleSurface = RippleSurface;
/**
 * HOC that adds ripples to any component
 */
var withRipple = function (_a) {
    var _b = _a === void 0 ? {} : _a, defaultUnbounded = _b.unbounded, defaultAccent = _b.accent, defaultSurface = _b.surface;
    return function (Component) {
        var WithRippleComponent = react_1.default.forwardRef(function (_a, ref) {
            var ripple = _a.ripple, rest = tslib_1.__rest(_a, ["ripple"]);
            var providerContext = provider_1.useProviderContext();
            ripple = ripple !== null && ripple !== void 0 ? ripple : providerContext.ripple;
            var rippleOptions = typeof ripple !== 'object' ? {} : ripple;
            if (ripple) {
                return (react_1.default.createElement(exports.Ripple, tslib_1.__assign({}, rest, { accent: rippleOptions.accent || defaultAccent, unbounded: rippleOptions.unbounded || defaultUnbounded, surface: rippleOptions.surface || defaultSurface }),
                    react_1.default.createElement(Component, tslib_1.__assign({}, rest, { ref: ref }))));
            }
            return react_1.default.createElement(Component, tslib_1.__assign({}, rest, { ref: ref }));
        });
        WithRippleComponent.displayName = "withRipple(" + (Component.displayName || Component.constructor.name || 'Unknown') + ")";
        return WithRippleComponent;
    };
};
exports.withRipple = withRipple;
