"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Ripples", lead: "MDC Ripple provides the JavaScript and CSS required to provide components (or any element at all) with a material \u201Cink ripple\u201D interaction effect. It is designed to be efficient, uninvasive, and usable without adding any extra DOM to your elements.", module: "@rmwc/ripple", styles: ['@material/ripple/dist/mdc.ripple.css'], docsLink: "https://material.io/develop/web/components/ripples/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Ripples will wrap whatever child component you pass it and apply the appropriate classes and styles."),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Ripple, null,
                react_1.default.createElement("p", null, "Standard Ripple"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Ripple, { primary: true },
                react_1.default.createElement("p", null, "Primary"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Ripple, { accent: true },
                react_1.default.createElement("p", null, "Accent"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, null,
            react_1.default.createElement(_1.Ripple, { unbounded: true },
                react_1.default.createElement("p", null, "Unbounded"))),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [{ displayName: 'Ripple', component: _1.Ripple }] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(react_1.default.Fragment, null,
    react_1.default.createElement(_1.Ripple, { unbounded: true },
        react_1.default.createElement("p", { style: {
                width: '6rem',
                height: '6rem',
                lineHeight: '6rem',
                textAlign: 'center'
            }, className: "mdc-ripple-upgraded--foreground-activation" }, "Ripple"))));
