import { __assign, __rest } from "tslib";
import { useCallback, useRef, useEffect } from 'react';
import { useFoundation, emptyClientRect } from '@rmwc/base';
import { matches } from '@rmwc/base';
import { MDCRippleFoundation, util } from '@material/ripple';
export var useRippleFoundation = function (props) {
    var isTouched = useRef(false);
    var _a = useFoundation({
        props: props,
        elements: {
            rootEl: true,
            surfaceEl: true
        },
        foundation: function (_a) {
            var rootEl = _a.rootEl, surfaceEl = _a.surfaceEl, getProps = _a.getProps;
            return new MDCRippleFoundation({
                browserSupportsCssVars: function () { return util.supportsCssVariables(window); },
                isUnbounded: function () { return !!getProps().unbounded; },
                isSurfaceActive: function () {
                    if (rootEl.ref) {
                        return matches(rootEl.ref, ':active');
                    }
                    return false;
                },
                isSurfaceDisabled: function () { return !!getProps().disabled; },
                addClass: function (className) {
                    surfaceEl.addClass(className);
                },
                removeClass: function (className) {
                    surfaceEl.removeClass(className);
                },
                containsEventTarget: function (target) {
                    return !!rootEl.ref && rootEl.ref.contains(target);
                },
                registerInteractionHandler: function (evtType, handler) { },
                deregisterInteractionHandler: function (evtType, handler) { },
                registerDocumentInteractionHandler: function (evtType, handler) {
                    return document.documentElement.addEventListener(evtType, handler, {
                        passive: true
                    });
                },
                deregisterDocumentInteractionHandler: function (evtType, handler) { return document.documentElement.removeEventListener(evtType, handler); },
                registerResizeHandler: function (handler) { return window.addEventListener('resize', handler); },
                deregisterResizeHandler: function (handler) { return window.removeEventListener('resize', handler); },
                updateCssVariable: function (varName, value) {
                    return surfaceEl.setStyle(varName, value);
                },
                computeBoundingRect: function () {
                    return rootEl.ref ? rootEl.ref.getBoundingClientRect() : emptyClientRect;
                },
                getWindowPageOffset: function () { return ({
                    x: window.pageXOffset,
                    y: window.pageYOffset
                }); }
            });
        }
    }), foundation = _a.foundation, elements = __rest(_a, ["foundation"]);
    var rootEl = elements.rootEl;
    var activateRipple = useCallback(function (evt) {
        // https://reactjs.org/docs/events.html#event-pooling
        evt.persist();
        foundation.activate(evt);
    }, [foundation]);
    var deactivateRipple = useCallback(function (evt) {
        // https://reactjs.org/docs/events.html#event-pooling
        evt.persist();
        foundation.deactivate();
    }, [foundation]);
    var onFocus = props.onFocus;
    var handleFocus = useCallback(function (evt) {
        onFocus === null || onFocus === void 0 ? void 0 : onFocus(evt);
        foundation.handleFocus();
    }, [foundation, onFocus]);
    var onBlur = props.onBlur;
    var handleBlur = useCallback(function (evt) {
        onBlur === null || onBlur === void 0 ? void 0 : onBlur(evt);
        foundation.handleBlur();
    }, [foundation, onBlur]);
    var onMouseDown = props.onMouseDown;
    var handleMouseDown = useCallback(function (evt) {
        onMouseDown === null || onMouseDown === void 0 ? void 0 : onMouseDown(evt);
        if (!isTouched.current) {
            activateRipple(evt);
        }
        isTouched.current = false;
    }, [onMouseDown, activateRipple]);
    var onMouseUp = props.onMouseUp;
    var handleMouseUp = useCallback(function (evt) {
        onMouseUp === null || onMouseUp === void 0 ? void 0 : onMouseUp(evt);
        deactivateRipple(evt);
    }, [onMouseUp, deactivateRipple]);
    var onTouchStart = props.onTouchStart;
    var handleTouchStart = useCallback(function (evt) {
        isTouched.current = true;
        onTouchStart === null || onTouchStart === void 0 ? void 0 : onTouchStart(evt);
        activateRipple(evt);
    }, [onTouchStart, activateRipple]);
    var onTouchEnd = props.onTouchEnd;
    var handleTouchEnd = useCallback(function (evt) {
        onTouchEnd === null || onTouchEnd === void 0 ? void 0 : onTouchEnd(evt);
        deactivateRipple(evt);
    }, [onTouchEnd, deactivateRipple]);
    var onKeyDown = props.onKeyDown;
    var handleKeyDown = useCallback(function (evt) {
        onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(evt);
        activateRipple(evt);
    }, [onKeyDown, activateRipple]);
    var onKeyUp = props.onKeyUp;
    var handleKeyUp = useCallback(function (evt) {
        onKeyUp === null || onKeyUp === void 0 ? void 0 : onKeyUp(evt);
        deactivateRipple(evt);
    }, [onKeyUp, deactivateRipple]);
    rootEl.setProp('onFocus', handleFocus, true);
    rootEl.setProp('onBlur', handleBlur, true);
    rootEl.setProp('onMouseDown', handleMouseDown, true);
    rootEl.setProp('onMouseUp', handleMouseUp, true);
    rootEl.setProp('onTouchStart', handleTouchStart, true);
    rootEl.setProp('onTouchEnd', handleTouchEnd, true);
    rootEl.setProp('onKeyDown', handleKeyDown, true);
    rootEl.setProp('onKeyUp', handleKeyUp, true);
    useEffect(function () {
        rootEl.setRef(props.domNode);
    }, [rootEl, props.domNode]);
    useEffect(function () {
        foundation.setUnbounded(!!props.unbounded);
    }, [props.unbounded, foundation]);
    useEffect(function () {
        props.disabled && foundation.handleBlur();
    }, [props.disabled, foundation]);
    return __assign({}, elements);
};
