import { __assign, __extends, __rest } from "tslib";
import React from 'react';
import * as ReactDOM from 'react-dom';
import { classNames } from '@rmwc/base';
import { useProviderContext } from '@rmwc/provider';
import { useRippleFoundation } from './foundation';
var RippleSurfaceContext = React.createContext({});
/** A component for adding Ripples to other components. */
var withDomNode = function () { return function (Component) {
    // @ts-ignore
    return /** @class */ (function (_super) {
        __extends(class_1, _super);
        function class_1() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.state = { domNode: null };
            return _this;
        }
        class_1.prototype.componentDidMount = function () {
            this.setState({ domNode: ReactDOM.findDOMNode(this) });
        };
        class_1.prototype.componentDidUpdate = function () {
            var rootRippleElement = ReactDOM.findDOMNode(this);
            if (rootRippleElement !== this.state.domNode) {
                this.setState({ rootRippleElement: rootRippleElement });
            }
        };
        class_1.prototype.render = function () {
            return React.createElement(Component, __assign({}, this.props, { domNode: this.state.domNode }));
        };
        return class_1;
    }(React.Component));
}; };
export var Ripple = withDomNode()(function Ripple(props) {
    var children = props.children, className = props.className, primary = props.primary, accent = props.accent, unbounded = props.unbounded, surface = props.surface, domNode = props.domNode, foundationRef = props.foundationRef, rest = __rest(props, ["children", "className", "primary", "accent", "unbounded", "surface", "domNode", "foundationRef"]);
    var _a = useRippleFoundation(props), rootEl = _a.rootEl, surfaceEl = _a.surfaceEl;
    var child = React.Children.only(children);
    if (!React.isValidElement(child)) {
        return null;
    }
    // This flag really determines a lot
    // is surfaceIsRoot is true, then the surface props are spread
    // to the underlying component, otherwise the only place they
    // can be picked up is by the context consumer
    var surfaceIsRoot = !surface || !unbounded;
    var unboundedProp = unbounded
        ? { 'data-mdc-ripple-is-unbounded': true }
        : {};
    var rippleSurfaceProps = surfaceIsRoot
        ? surfaceEl.props({ style: child.props.style })
        : {};
    var finalClassNames = classNames(className !== child.props.className && className, rippleSurfaceProps.className, child.props.className, {
        'mdc-ripple-surface': typeof surface === 'boolean' ? surface : surface === undefined,
        'mdc-ripple-surface--primary': primary,
        'mdc-ripple-surface--accent': accent
    });
    // Fixes a ripple artifact issue
    // that is caused when clicking a button disables it
    // https://codesandbox.io/s/842vo56019
    if (rest.disabled) {
        finalClassNames = finalClassNames.replace('mdc-ripple-upgraded--background-focused', '');
    }
    // do some crazy props merging...
    var content = React.cloneElement(child, __assign(__assign(__assign({}, child.props), unboundedProp), rootEl.props(__assign(__assign(__assign(__assign({}, rest), { style: child.props.style }), rippleSurfaceProps), { className: finalClassNames }))));
    return (React.createElement(RippleSurfaceContext.Provider, { value: surfaceEl.props({ style: child.props.style }) }, content));
});
export var RippleSurface = function (_a) {
    var className = _a.className, rest = __rest(_a, ["className"]);
    return (React.createElement(RippleSurfaceContext.Consumer, null, function (rippleSurfaceProps) { return (React.createElement("div", __assign({}, rest, rippleSurfaceProps, { className: className + " " + (rippleSurfaceProps.className || '') }))); }));
};
/**
 * HOC that adds ripples to any component
 */
export var withRipple = function (_a) {
    var _b = _a === void 0 ? {} : _a, defaultUnbounded = _b.unbounded, defaultAccent = _b.accent, defaultSurface = _b.surface;
    return function (Component) {
        var WithRippleComponent = React.forwardRef(function (_a, ref) {
            var ripple = _a.ripple, rest = __rest(_a, ["ripple"]);
            var providerContext = useProviderContext();
            ripple = ripple !== null && ripple !== void 0 ? ripple : providerContext.ripple;
            var rippleOptions = typeof ripple !== 'object' ? {} : ripple;
            if (ripple) {
                return (React.createElement(Ripple, __assign({}, rest, { accent: rippleOptions.accent || defaultAccent, unbounded: rippleOptions.unbounded || defaultUnbounded, surface: rippleOptions.surface || defaultSurface }),
                    React.createElement(Component, __assign({}, rest, { ref: ref }))));
            }
            return React.createElement(Component, __assign({}, rest, { ref: ref }));
        });
        WithRippleComponent.displayName = "withRipple(" + (Component.displayName || Component.constructor.name || 'Unknown') + ")";
        return WithRippleComponent;
    };
};
