import React from 'react';
import { Docs, DocsExample, DocProps, DocsP } from '@doc-utils';
import propsSrc from './generated-props.json';
import examples from './generated-examples.json';
import { Ripple } from '.';
export default function Readme() {
    return (React.createElement(Docs, { title: "Ripples", lead: "MDC Ripple provides the JavaScript and CSS required to provide components (or any element at all) with a material \u201Cink ripple\u201D interaction effect. It is designed to be efficient, uninvasive, and usable without adding any extra DOM to your elements.", module: "@rmwc/ripple", styles: ['@material/ripple/dist/mdc.ripple.css'], docsLink: "https://material.io/develop/web/components/ripples/", examples: examples },
        React.createElement(DocsP, null, "Ripples will wrap whatever child component you pass it and apply the appropriate classes and styles."),
        React.createElement(DocsExample, null,
            React.createElement(Ripple, null,
                React.createElement("p", null, "Standard Ripple"))),
        React.createElement(DocsExample, null,
            React.createElement(Ripple, { primary: true },
                React.createElement("p", null, "Primary"))),
        React.createElement(DocsExample, null,
            React.createElement(Ripple, { accent: true },
                React.createElement("p", null, "Accent"))),
        React.createElement(DocsExample, null,
            React.createElement(Ripple, { unbounded: true },
                React.createElement("p", null, "Unbounded"))),
        React.createElement(DocProps, { src: propsSrc, components: [{ displayName: 'Ripple', component: Ripple }] })));
}
export var galleryExample = (React.createElement(React.Fragment, null,
    React.createElement(Ripple, { unbounded: true },
        React.createElement("p", { style: {
                width: '6rem',
                height: '6rem',
                lineHeight: '6rem',
                textAlign: 'center'
            }, className: "mdc-ripple-upgraded--foreground-activation" }, "Ripple"))));
