"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSnackbarFoundation = void 0;
var tslib_1 = require("tslib");
var react_1 = require("react");
var snackbar_1 = require("@material/snackbar");
var base_1 = require("@rmwc/base");
var base_2 = require("@rmwc/base");
/** Monkey patch the foundation to accept dynamic reasons rather than just "action" */
// @ts-ignore
snackbar_1.MDCSnackbarFoundation.prototype.handleActionButtonClick = function (evt, reason) {
    this.close(reason);
};
function useSnackbarFoundation(props) {
    var _a = base_2.useFoundation({
        props: props,
        elements: {
            rootEl: true,
            surfaceEl: true,
            labelEl: true
        },
        foundation: function (_a) {
            var rootEl = _a.rootEl, labelEl = _a.labelEl, emit = _a.emit;
            return new snackbar_1.MDCSnackbarFoundation({
                addClass: function (className) { return rootEl.addClass(className); },
                removeClass: function (className) { return rootEl.removeClass(className); },
                announce: function () { return labelEl.ref && snackbar_1.util.announce(labelEl.ref); },
                notifyOpening: function () { return emit('onOpen', {}); },
                notifyOpened: function () {
                    base_1.triggerWindowResize();
                    emit('onOpened', {});
                },
                notifyClosing: function (reason) {
                    emit('onClose', reason ? { reason: reason } : {});
                },
                notifyClosed: function (reason) {
                    return emit('onClosed', reason ? { reason: reason } : {});
                }
            });
        }
    }), foundation = _a.foundation, elements = tslib_1.__rest(_a, ["foundation"]);
    var rootEl = elements.rootEl, surfaceEl = elements.surfaceEl;
    var handleKeyDown = function (evt) {
        props.onKeyDown && props.onKeyDown(evt);
        foundation.handleKeyDown(evt);
    };
    var handleSurfaceClick = function (evt) {
        if (evt.target instanceof Element) {
            var el = evt.target;
            var button = base_1.closest(el, '.mdc-button');
            if (button) {
                el = button;
            }
            if (props.dismissesOnAction &&
                el.classList.contains('mdc-snackbar__action')) {
                foundation.handleActionButtonClick(evt, 
                // @ts-ignore
                el.dataset.mdcSnackbarAction);
            }
            else if (el.classList.contains('mdc-snackbar__dismiss')) {
                foundation.handleActionIconClick(evt);
            }
        }
    };
    rootEl.setProp('onKeyDown', handleKeyDown, true);
    surfaceEl.setProp('onClick', handleSurfaceClick, true);
    // open
    react_1.useEffect(function () {
        props.open ? foundation.open() : foundation.close();
    }, [props.open, foundation]);
    // timeout
    react_1.useEffect(function () {
        if (props.timeout) {
            if (props.timeout === -1) {
                foundation.setTimeoutMs(props.timeout);
            }
            else {
                // don't tell me what I can cant set my timeout too...
                // directly patch over using setTimeoutMs
                foundation.autoDismissTimeoutMs_ = props.timeout;
            }
        }
    }, [props.timeout, foundation]);
    return tslib_1.__assign({ foundation: foundation }, elements);
}
exports.useSnackbarFoundation = useSnackbarFoundation;
