"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require("./");
var button_1 = require("@rmwc/button");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Snackbars", lead: "Snackbars provide brief feedback about an operation through a message at the bottom of the screen.", module: "@rmwc/snackbar", styles: [
            '@material/snackbar/dist/mdc.snackbar.css',
            '@material/button/dist/mdc.button.css',
            '@material/ripple/dist/mdc.ripple.css'
        ], docsLink: "https://material.io/develop/web/components/snackbars/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Basic Usage"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "You can render a snackbar in your UI and control its open state."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Default" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState(false), 2), open = _a[0], setOpen = _a[1];
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.Snackbar, { open: open, onClose: function (evt) { return setOpen(false); }, message: "This is a new message", dismissesOnAction: true, action: react_1.default.createElement(_1.SnackbarAction, { label: "Dismiss", onClick: function () { return console.log('Click Me'); } }) }),
                react_1.default.createElement(button_1.Button, { raised: true, label: "Show snackbar", onClick: function (evt) { return setOpen(!open); } })));
        }),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Start Aligned" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState(false), 2), open = _a[0], setOpen = _a[1];
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.Snackbar, { open: open, onClose: function (evt) { return setOpen(false); }, message: "Start aligned, open until dismissed", stacked: true, dismissesOnAction: true, action: [
                        react_1.default.createElement(_1.SnackbarAction, { label: "Yeah!" }),
                        react_1.default.createElement(_1.SnackbarAction, { label: "No..." })
                    ], leading: true, timeout: -1 }),
                react_1.default.createElement(button_1.Button, { raised: true, label: "Show start-aligned", onClick: function (evt) { return setOpen(!open); } })));
        }),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Usage with SnackbarQueue"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "While rendering the Snackbar inline works for simple cases, you'll likely have a notification system, or want to send notifications from anywhere in your app. The `SnackbarQueue` exists as a convenient interface for handling these cases and rendering the snackbar messages for you. If you've used the `DialogQueue`, the `SnackbarQueue` is very similar."),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Setup is nice and easy, create a queue object you can pass around in your code base, pass the queues `messages` to the `SnackbarQueue` component, and then use the `notify` function to send notifications."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { codeOnly: true }, 
        /* jsx */ "\n        // Create a file that exports your queue\n        // myQueue.js\n        import { createSnackbarQueue } from '@rmwc/snackbar';\n\n        export const queue = createSnackbarQueue();\n      "),
        react_1.default.createElement(_doc_utils_1.DocsExample, { codeOnly: true }, 
        /* jsx */ "\n        // Somewhere at the top level of your app\n        // Render the SnackbarQueue\n        import React from 'react';\n        import { queue } from './myQueue';\n\n        export default function App() {\n          return (\n            <div>\n              ...\n              <SnackbarQueue\n                messages={queue.messages}\n                // You can also pass default options to pass to your notifications\n                // ie, make them all leading, stacked, etc\n                leading\n                stacked\n              />\n            </div>\n          )\n        }\n        \n      "),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "The `notify` function was designed to mimic the the built-in browser Notifications api and can accept most of the relevant options (icon, image, title, body, actions, ,etc). It also can accept any of the Snackbar props. Just import your queue, and call the notify method."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { codeOnly: true }, 
        /* jsx */ "\n        // Somewhere else in your app\n        // Could be a view, your redux store, anywhere you want...\n        import { queue } from './myQueue';\n\n        // Simple example\n        queue.notify({\n          title: 'Hi there'\n        });\n\n        // With some features\n        queue.notify({\n          title: <b>Warning</b>,\n          body: 'You have selected pizza instead icecream!',\n          icon: 'warning',\n          actions: [\n            {\n              // NotificationAction api format\n              title: 'Fix It!',\n              icon: 'close',\n              action: 'fixit' // action will be available as evt.detail.reason in the onClose event\n            },\n            {\n              // OR SnackbarActionProps format\n              label: 'Continue...',\n              icon: 'check',\n              onClick: () => {}\n            },\n          ]\n        });\n      "),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Inline Example" }, function () {
            var _a = _1.createSnackbarQueue(), messages = _a.messages, notify = _a.notify;
            function App() {
                return (react_1.default.createElement("div", null,
                    react_1.default.createElement(button_1.Button, { label: "Notify", onClick: function () {
                            return notify({
                                title: react_1.default.createElement("b", null, "Success"),
                                body: 'You have selected pizza!',
                                dismissesOnAction: true,
                                icon: 'check',
                                actions: [
                                    {
                                        title: 'Dismiss'
                                    }
                                ]
                            });
                        } }),
                    react_1.default.createElement(_1.SnackbarQueue, { messages: messages })));
            }
            return react_1.default.createElement(App, null);
        }),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'Snackbar', component: _1.Snackbar },
                { displayName: 'SnackbarAction', component: _1.SnackbarAction }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(_1.Snackbar, { open: true, timeout: 999999999, message: "This is a new message", style: { transform: 'scale(0.75)', position: 'static' }, action: react_1.default.createElement(_1.SnackbarAction, { label: "Dismiss", onClick: function () { return console.log('Click Me'); } }) }));
