"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSnackbarQueue = exports.SnackbarQueue = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var snackbar_1 = require("./snackbar");
var base_1 = require("@rmwc/base");
/** A snackbar queue for rendering messages */
function SnackbarQueue(_a) {
    var messages = _a.messages, defaultSnackbarProps = tslib_1.__rest(_a, ["messages"]);
    var currentMessage = messages.array[0];
    var _b = tslib_1.__read(react_1.useState(0), 2), setIteration = _b[1];
    var _c = tslib_1.__read(react_1.useState(messages.array[0]), 2), message = _c[0], setMessage = _c[1];
    var removeMessage = react_1.useCallback(function (message) {
        message && messages.remove(message);
    }, [messages]);
    react_1.useEffect(function () {
        var timerId;
        var doChange = function () {
            if (messages.array[0] !== message) {
                setIteration(function (val) { return val + 1; });
                timerId = window.setTimeout(function () { return setMessage(messages.array[0]); }, 150);
            }
        };
        messages.on('change', doChange);
        return function () {
            timerId && clearTimeout(timerId);
            messages.off('change', doChange);
        };
    }, [messages, message]);
    var _d = message || {}, _e = _d.body, body = _e === void 0 ? '' : _e, image = _d.image, _f = _d.title, title = _f === void 0 ? '' : _f, onClose = _d.onClose, actions = _d.actions, messageSnackbarProps = tslib_1.__rest(_d, ["body", "image", "title", "onClose", "actions"]);
    var actionProp = actions
        ? actions.map(function (_a) {
            var title = _a.title, label = _a.label, rest = tslib_1.__rest(_a, ["title", "label"]);
            return (react_1.default.createElement(snackbar_1.SnackbarAction, tslib_1.__assign({}, rest, { label: label || title })));
        })
        : null;
    // We are open if we have a message
    // and the current one is the one in state
    var open = message && message === currentMessage;
    return (react_1.default.createElement(snackbar_1.Snackbar, tslib_1.__assign({}, defaultSnackbarProps, messageSnackbarProps, { open: open, message: react_1.default.createElement(react_1.default.Fragment, null,
            title,
            !!title && !!body && react_1.default.createElement("br", null),
            body,
            !!image && (react_1.default.createElement("div", { className: "rmwc-snackbar__image", style: {
                    margin: '1rem auto',
                    textAlign: 'center'
                } },
                react_1.default.createElement("img", { src: image, alt: "" + image, style: { maxWidth: '100%', maxHeight: '18rem' } })))), onClose: function (evt) {
            onClose === null || onClose === void 0 ? void 0 : onClose(evt);
            removeMessage(message);
        }, action: actionProp })));
}
exports.SnackbarQueue = SnackbarQueue;
/** Creates a snackbar queue */
var createSnackbarQueue = function () {
    var messages = new base_1.ArrayEmitter();
    return {
        messages: messages,
        clearAll: function () { return messages.empty(); },
        notify: function (message) {
            messages.push(message);
            return {
                close: function () {
                    messages.remove(message);
                }
            };
        }
    };
};
exports.createSnackbarQueue = createSnackbarQueue;
