"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnackbarAction = exports.Snackbar = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var snackbar_1 = require("@material/snackbar");
var button_1 = require("@rmwc/button");
var base_1 = require("@rmwc/base");
var foundation_1 = require("./foundation");
var icon_button_1 = require("@rmwc/icon-button");
var icon_1 = require("@rmwc/icon");
/** A Snackbar component for notifications. */
exports.Snackbar = base_1.createComponent(function Snackbar(props, ref) {
    var _a = foundation_1.useSnackbarFoundation(props), rootEl = _a.rootEl, surfaceEl = _a.surfaceEl, labelEl = _a.labelEl;
    var open = props.open, message = props.message, timeout = props.timeout, dismissIcon = props.dismissIcon, onOpen = props.onOpen, onClose = props.onClose, children = props.children, action = props.action, icon = props.icon, leading = props.leading, stacked = props.stacked, dismissesOnAction = props.dismissesOnAction, foundationRef = props.foundationRef, rest = tslib_1.__rest(props, ["open", "message", "timeout", "dismissIcon", "onOpen", "onClose", "children", "action", "icon", "leading", "stacked", "dismissesOnAction", "foundationRef"]);
    var className = base_1.useClassNames(props, [
        'mdc-snackbar',
        {
            'mdc-snackbar--leading': leading,
            'mdc-snackbar--stacked': stacked
        }
    ]);
    var actions = Array.isArray(action)
        ? action
        : action
            ? [action]
            : [];
    return (react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, element: rootEl, "aria-live": "assertive", "aria-atomic": true, "aria-hidden": true, className: className }),
        react_1.default.createElement("div", tslib_1.__assign({}, surfaceEl.props({}), { className: "mdc-snackbar__surface" }),
            !!icon && (react_1.default.createElement(icon_1.Icon, { style: {
                    color: 'rgba(255, 255, 255, 0.87)',
                    fill: 'currentColor',
                    marginLeft: '1rem'
                }, icon: icon })),
            react_1.default.createElement(SnackbarLabel, null,
                message,
                react_1.default.createElement("div", { style: { display: 'none' }, ref: labelEl.setRef })),
            react_1.default.createElement(SnackbarActions, null,
                actions.map(function (a, i) { return (react_1.default.createElement(react_1.default.Fragment, { key: i }, a)); }),
                dismissIcon && (react_1.default.createElement(SnackbarDismiss, { icon: dismissIcon === true ? 'close' : dismissIcon }))),
            children)));
});
/*********************************************************************
 * Bits
 *********************************************************************/
function SnackbarLabel(props) {
    return (react_1.default.createElement("div", tslib_1.__assign({ role: "status", "aria-live": "polite", className: "mdc-snackbar__label" }, props)));
}
function SnackbarActions(props) {
    return react_1.default.createElement("div", tslib_1.__assign({ className: "mdc-snackbar__actions" }, props));
}
/** A button for a snackbar action. */
exports.SnackbarAction = base_1.createComponent(function SnackbarAction(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-snackbar__action']);
    var _a = props.action, action = _a === void 0 ? snackbar_1.MDCSnackbarFoundation.strings.REASON_ACTION : _a, rest = tslib_1.__rest(props, ["action"]);
    return (react_1.default.createElement(button_1.Button, tslib_1.__assign({}, rest, { className: className, ref: ref, "data-mdc-snackbar-action": action })));
});
function SnackbarDismiss(props) {
    return react_1.default.createElement(icon_button_1.IconButton, tslib_1.__assign({}, props, { className: "mdc-snackbar__dismiss" }));
}
