"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Tabs", lead: "Tabs make it easy to explore and switch between different views.", module: "@rmwc/tabs", styles: [
            '@material/tab-bar/dist/mdc.tab-bar.css',
            '@material/tab/dist/mdc.tab.css',
            '@material/tab-scroller/dist/mdc.tab-scroller.css',
            '@material/tab-indicator/dist/mdc.tab-indicator.css',
            '@material/ripple/dist/mdc.ripple.css',
            '@rmwc/icon/icon.css'
        ], docsLink: "https://material.io/develop/web/components/tabs/tab-bar/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Basic Usage"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Tabs can be either controlled or uncontrolled just like inputs. Use the `activeTabIndex` and `onActivate` callback for controlled components."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Uncontrolled" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, null, "Cookies"),
                react_1.default.createElement(_1.Tab, null, "Pizza"),
                react_1.default.createElement(_1.Tab, null, "Icecream"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Controlled" }, function Example() {
            var _a = tslib_1.__read(react_1.default.useState(0), 2), activeTab = _a[0], setActiveTab = _a[1];
            return (react_1.default.createElement(_1.TabBar, { activeTabIndex: activeTab, onActivate: function (evt) { return setActiveTab(evt.detail.index); } },
                react_1.default.createElement(_1.Tab, null, "Cookies"),
                react_1.default.createElement(_1.Tab, null, "Pizza"),
                react_1.default.createElement(_1.Tab, null, "Icecream")));
        }),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Variants"),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Basic" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, null, "Cookies"),
                react_1.default.createElement(_1.Tab, null, "Pizza"),
                react_1.default.createElement(_1.Tab, null, "Icecream"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "With Icons" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, { icon: "star_border", label: "Cookies" }),
                react_1.default.createElement(_1.Tab, { icon: "favorite_border", label: "Pizza" }),
                react_1.default.createElement(_1.Tab, { icon: "mood", label: "Icecream" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Icons Only" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, { icon: "star_border" }),
                react_1.default.createElement(_1.Tab, { icon: "favorite_border" }),
                react_1.default.createElement(_1.Tab, { icon: "mood" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Stacked" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, { stacked: true, icon: "star_border", label: "Cookies" }),
                react_1.default.createElement(_1.Tab, { stacked: true, icon: "favorite_border", label: "Pizza" }),
                react_1.default.createElement(_1.Tab, { stacked: true, icon: "mood", label: "Icecream" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Restricted Indicator" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, { stacked: true, restrictIndicator: true, icon: "star_border", label: "Cookies" }),
                react_1.default.createElement(_1.Tab, { stacked: true, restrictIndicator: true, icon: "favorite_border", label: "Pizza" }),
                react_1.default.createElement(_1.Tab, { stacked: true, restrictIndicator: true, icon: "mood", label: "Icecream" }))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Scrollable" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, null, "Cookies"),
                react_1.default.createElement(_1.Tab, null, "Pizza"),
                react_1.default.createElement(_1.Tab, null, "Icecream"),
                react_1.default.createElement(_1.Tab, null, "Chocolate"),
                react_1.default.createElement(_1.Tab, null, "Fishsticks"),
                react_1.default.createElement(_1.Tab, null, "Ratatouille"),
                react_1.default.createElement(_1.Tab, null, "Bread"),
                react_1.default.createElement(_1.Tab, null, "Rolls"),
                react_1.default.createElement(_1.Tab, null, "Sushi"),
                react_1.default.createElement(_1.Tab, null, "Cupcake"),
                react_1.default.createElement(_1.Tab, null, "Cheesecake"))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Transitions"),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Slide (Default)" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, null, "Cookies"),
                react_1.default.createElement(_1.Tab, null, "Pizza"),
                react_1.default.createElement(_1.Tab, null, "Icecream"))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Icons as Indicators"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "`material-components-web` has some light support for using icons as indicators (it's buried in their docs but there are no working examples or demos). Support has been added to RMWC, but your mileage may vary since it will require quite a bit of manual positioning and styling. By default, the icons appear full size at the center of the tab, effectively making them overlay images."),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Default Positioning" },
            react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, { iconIndicator: "star" }, "Cookies"),
                react_1.default.createElement(_1.Tab, { iconIndicator: "favorite" }, "Pizza"),
                react_1.default.createElement(_1.Tab, { iconIndicator: "mood" }, "Icecream"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Manually Positioned" }, function IconIndicatorExample() {
            var style = {
                transformOrigin: 'center center',
                transform: 'translateY(1rem) scale(0.45)'
            };
            return (react_1.default.createElement(_1.TabBar, null,
                react_1.default.createElement(_1.Tab, { label: "Cookies", iconIndicator: {
                        icon: 'star',
                        style: style
                    } }),
                react_1.default.createElement(_1.Tab, { label: "Pizza", iconIndicator: {
                        icon: 'favorite',
                        style: style
                    } }),
                react_1.default.createElement(_1.Tab, { label: "Icecream", iconIndicator: {
                        icon: 'mood',
                        style: style
                    } })));
        }),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'TabBar', component: _1.TabBar },
                { displayName: 'Tab', component: _1.Tab }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement("div", { style: { margin: '1rem' } },
    react_1.default.createElement(_1.TabBar, null,
        react_1.default.createElement(_1.Tab, null, "One"),
        react_1.default.createElement(_1.Tab, null, "Two"),
        react_1.default.createElement(_1.Tab, null, "Three"))));
