"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabBar = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var base_1 = require("@rmwc/base");
var tab_scroller_1 = require("./tab-scroller");
var tab_bar_context_1 = require("./tab-bar-context");
var tab_bar_foundation_1 = require("./tab-bar-foundation");
exports.TabBar = base_1.createComponent(function TabBar(props, ref) {
    var children = props.children, activeTabIndex = props.activeTabIndex, onActivate = props.onActivate, foundationRef = props.foundationRef, rest = tslib_1.__rest(props, ["children", "activeTabIndex", "onActivate", "foundationRef"]);
    var _a = tab_bar_foundation_1.useTabBarFoundation(props), rootEl = _a.rootEl, handleTabInteraction = _a.handleTabInteraction, setTabScrollerApi = _a.setTabScrollerApi, registerTab = _a.registerTab, unregisterTab = _a.unregisterTab;
    var contextApi = react_1.useRef({
        onTabInteraction: function (evt) {
            return handleTabInteraction(evt);
        },
        registerTab: registerTab,
        unregisterTab: unregisterTab,
        indicatorTransition: props.indicatorTransition || 'slide'
    });
    var className = base_1.useClassNames(props, ['mdc-tab-bar']);
    return (react_1.default.createElement(tab_bar_context_1.TabBarContext.Provider, { value: contextApi.current },
        react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "nav", element: rootEl }, rest, { className: className, ref: ref }),
            react_1.default.createElement(tab_scroller_1.TabScroller, { apiRef: setTabScrollerApi }, children))));
});
