"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTabIndicatorFoundation = void 0;
var tslib_1 = require("tslib");
var base_1 = require("@rmwc/base");
var tab_indicator_1 = require("@material/tab-indicator");
var useTabIndicatorFoundation = function (props) {
    var _a = base_1.useFoundation({
        props: props,
        elements: { rootEl: true, contentEl: true },
        foundation: function (_a) {
            var rootEl = _a.rootEl, contentEl = _a.contentEl;
            var adapter = {
                addClass: function (className) {
                    rootEl.addClass(className);
                },
                removeClass: function (className) {
                    rootEl.removeClass(className);
                },
                computeContentClientRect: function () {
                    return contentEl.ref
                        ? contentEl.ref.getBoundingClientRect()
                        : base_1.emptyClientRect;
                },
                setContentStyleProperty: function (prop, value) {
                    contentEl.setStyle(prop, value);
                }
            };
            if (props.transition === 'fade') {
                return new tab_indicator_1.MDCFadingTabIndicatorFoundation(adapter);
            }
            return new tab_indicator_1.MDCSlidingTabIndicatorFoundation(adapter);
        },
        api: function (_a) {
            var foundation = _a.foundation;
            return {
                activate: function (previousIndicatorClientRect) {
                    foundation.activate(previousIndicatorClientRect);
                },
                deactivate: function () {
                    foundation.deactivate();
                },
                computeContentClientRect: function () {
                    return foundation.computeContentClientRect();
                }
            };
        }
    }), foundation = _a.foundation, elements = tslib_1.__rest(_a, ["foundation"]);
    return tslib_1.__assign({}, elements);
};
exports.useTabIndicatorFoundation = useTabIndicatorFoundation;
