"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabIndicator = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var base_1 = require("@rmwc/base");
var icon_1 = require("@rmwc/icon");
var tab_indicator_foundation_1 = require("./tab-indicator-foundation");
function TabIndicator(props) {
    var _a = tab_indicator_foundation_1.useTabIndicatorFoundation(props), rootEl = _a.rootEl, contentEl = _a.contentEl;
    var icon = props.icon, transition = props.transition;
    return (react_1.default.createElement(base_1.Tag, { tag: "span", element: rootEl, className: base_1.classNames('mdc-tab-indicator', {
            'mdc-tab-indicator--fade': transition === 'fade'
        }) },
        react_1.default.createElement(base_1.Tag, { tag: !!icon ? icon_1.Icon : 'span', "aria-hidden": "true", 
            // @ts-ignore icon prop not always present, this is ok
            icon: icon, element: contentEl, className: "mdc-tab-indicator__content mdc-tab-indicator__content--" + (icon ? 'icon' : 'underline') })));
}
exports.TabIndicator = TabIndicator;
