"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTabScrollerFoundation = void 0;
var tslib_1 = require("tslib");
var base_1 = require("@rmwc/base");
var base_2 = require("@rmwc/base");
var tab_scroller_1 = require("@material/tab-scroller");
var useTabScrollerFoundation = function (props) {
    var _a = base_1.useFoundation({
        props: props,
        api: function (_a) {
            var foundation = _a.foundation, contentEl = _a.contentEl;
            var f = foundation;
            return {
                scrollTo: function (scrollX) { return f.scrollTo(scrollX); },
                incrementScroll: function (scrollXIncrement) {
                    return f.incrementScroll(scrollXIncrement);
                },
                getScrollPosition: function () { return f.getScrollPosition(); },
                getScrollContentWidth: function () { var _a; return ((_a = contentEl.ref) === null || _a === void 0 ? void 0 : _a.offsetWidth) || 0; }
            };
        },
        elements: { rootEl: true, areaEl: true, contentEl: true },
        foundation: function (_a) {
            var rootEl = _a.rootEl, areaEl = _a.areaEl, contentEl = _a.contentEl;
            return new tab_scroller_1.MDCTabScrollerFoundation({
                eventTargetMatchesSelector: function (evtTarget, selector) { return base_2.matches(evtTarget, selector); },
                addClass: function (className) { return rootEl.addClass(className); },
                removeClass: function (className) { return rootEl.removeClass(className); },
                addScrollAreaClass: function (className) { return areaEl.addClass(className); },
                setScrollAreaStyleProperty: function (prop, value) {
                    return areaEl.setStyle(prop, value);
                },
                setScrollContentStyleProperty: function (prop, value) {
                    return contentEl.setStyle(prop, value);
                },
                getScrollContentStyleValue: function (propName) {
                    var val = contentEl.ref &&
                        window.getComputedStyle(contentEl.ref).getPropertyValue(propName);
                    return val || 'none';
                },
                setScrollAreaScrollLeft: function (scrollX) {
                    return areaEl.ref && (areaEl.ref.scrollLeft = scrollX);
                },
                getScrollAreaScrollLeft: function () { return (areaEl.ref ? areaEl.ref.scrollLeft : 0); },
                getScrollContentOffsetWidth: function () {
                    return contentEl.ref ? contentEl.ref.offsetWidth : 0;
                },
                getScrollAreaOffsetWidth: function () {
                    return areaEl.ref ? areaEl.ref.offsetWidth : 0;
                },
                computeScrollAreaClientRect: function () {
                    return areaEl.ref ? areaEl.ref.getBoundingClientRect() : base_1.emptyClientRect;
                },
                computeScrollContentClientRect: function () {
                    return contentEl.ref
                        ? contentEl.ref.getBoundingClientRect()
                        : base_1.emptyClientRect;
                },
                computeHorizontalScrollbarHeight: function () {
                    return tab_scroller_1.util.computeHorizontalScrollbarHeight(document);
                }
            });
        }
    }), foundation = _a.foundation, elements = tslib_1.__rest(_a, ["foundation"]);
    var areaEl = elements.areaEl, contentEl = elements.contentEl;
    var handleInteraction = function () {
        foundation.handleInteraction();
    };
    var handleTransitionEnd = function (evt) {
        foundation.handleTransitionEnd(evt);
    };
    areaEl.setProp('onWheel', handleInteraction, true);
    areaEl.setProp('onTouchStart', handleInteraction, true);
    areaEl.setProp('onPointerDown', handleInteraction, true);
    areaEl.setProp('onMouseDown', handleInteraction, true);
    areaEl.setProp('onKeyDown', handleInteraction, true);
    contentEl.setProp('onTransitionEnd', handleTransitionEnd, true);
    return tslib_1.__assign({}, elements);
};
exports.useTabScrollerFoundation = useTabScrollerFoundation;
