"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tab = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var base_1 = require("@rmwc/base");
var icon_1 = require("@rmwc/icon");
var ripple_1 = require("@rmwc/ripple");
var tab_bar_context_1 = require("./tab-bar-context");
var tab_indicator_1 = require("./tab-indicator");
var tab_foundation_1 = require("./tab-foundation");
var TabRoot = ripple_1.withRipple({ surface: false })(base_1.createComponent(function TabRoot(props, ref) {
    var stacked = props.stacked, minWidth = props.minWidth, rest = tslib_1.__rest(props, ["stacked", "minWidth"]);
    var className = base_1.useClassNames(props, [
        'mdc-tab',
        {
            'mdc-tab--stacked': stacked,
            'mdc-tab--min-width': minWidth
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "button" }, rest, { className: className, ref: ref }));
}));
/** A Tab icon. This is an instance of the Icon component. */
var TabIcon = react_1.default.memo(function TabIcon(props) {
    return react_1.default.createElement(icon_1.Icon, tslib_1.__assign({}, props, { className: "mdc-tab__icon" }));
});
/** A Tab component */
exports.Tab = base_1.createComponent(function Tab(props, ref) {
    var children = props.children, label = props.label, icon = props.icon, stacked = props.stacked, restrictIndicator = props.restrictIndicator, onInteraction = props.onInteraction, iconIndicator = props.iconIndicator, foundationRef = props.foundationRef, focusOnActivate = props.focusOnActivate, rest = tslib_1.__rest(props, ["children", "label", "icon", "stacked", "restrictIndicator", "onInteraction", "iconIndicator", "foundationRef", "focusOnActivate"]);
    var _a = tab_foundation_1.useTabFoundation(props), rootEl = _a.rootEl, contentEl = _a.contentEl, setTabIndicatorApi = _a.setTabIndicatorApi;
    var contextApi = react_1.default.useContext(tab_bar_context_1.TabBarContext);
    var tabIndicator = (react_1.default.createElement(tab_indicator_1.TabIndicator, { apiRef: setTabIndicatorApi, transition: contextApi.indicatorTransition, icon: iconIndicator }));
    return (react_1.default.createElement(TabRoot, tslib_1.__assign({ element: rootEl, stacked: stacked }, rest, { ref: ref }),
        react_1.default.createElement("div", { className: "mdc-tab__content", ref: contentEl.setRef },
            !!icon && react_1.default.createElement(TabIcon, { icon: icon }),
            (children !== undefined || label !== undefined) && (react_1.default.createElement("span", { className: "mdc-tab__text-label" },
                label,
                children)),
            !!restrictIndicator && tabIndicator),
        !restrictIndicator && tabIndicator,
        react_1.default.createElement(ripple_1.RippleSurface, { className: "mdc-tab__ripple" })));
});
