"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopAppBarFixedAdjust = exports.TopAppBarTitle = exports.TopAppBarActionItem = exports.TopAppBarNavigationIcon = exports.TopAppBarSection = exports.TopAppBarRow = exports.SimpleTopAppBar = exports.TopAppBar = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var base_1 = require("@rmwc/base");
var icon_button_1 = require("@rmwc/icon-button");
var foundation_1 = require("./foundation");
/** A TopAppBar component */
exports.TopAppBar = base_1.createComponent(function TopAppBar(props, ref) {
    return (react_1.default.createElement(TopAppBarBase, tslib_1.__assign({ key: props.short ? 'short' : props.fixed ? 'fixed' : 'top-app-bar' }, props, { ref: ref })));
});
var TopAppBarBase = base_1.createComponent(function TopAppBarBase(props, ref) {
    var rootEl = foundation_1.useTopAppBarFoundation(props).rootEl;
    var onNav = props.onNav, scrollTarget = props.scrollTarget, fixed = props.fixed, prominent = props.prominent, short = props.short, shortCollapsed = props.shortCollapsed, dense = props.dense, foundationRef = props.foundationRef, rest = tslib_1.__rest(props, ["onNav", "scrollTarget", "fixed", "prominent", "short", "shortCollapsed", "dense", "foundationRef"]);
    var className = base_1.useClassNames(props, [
        'mdc-top-app-bar',
        {
            'mdc-top-app-bar--fixed': fixed,
            'mdc-top-app-bar--prominent': prominent,
            'mdc-top-app-bar--short': short || shortCollapsed,
            'mdc-top-app-bar--short-collapsed': shortCollapsed,
            'mdc-top-app-bar--dense': dense
        }
    ]);
    return (react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "header" }, rest, { element: rootEl, className: className, ref: ref })));
});
/** A simplified syntax for creating an AppBar. */
exports.SimpleTopAppBar = base_1.createComponent(function SimpleTopAppBar(props, ref) {
    var title = props.title, actionItems = props.actionItems, navigationIcon = props.navigationIcon, startContent = props.startContent, endContent = props.endContent, rest = tslib_1.__rest(props, ["title", "actionItems", "navigationIcon", "startContent", "endContent"]);
    return (react_1.default.createElement(exports.TopAppBar, tslib_1.__assign({}, rest, { ref: ref }),
        react_1.default.createElement(exports.TopAppBarRow, null,
            react_1.default.createElement(exports.TopAppBarSection, { alignStart: true },
                !!navigationIcon && (react_1.default.createElement(exports.TopAppBarNavigationIcon, tslib_1.__assign({ icon: "menu" }, (typeof navigationIcon === 'boolean' ? {} : navigationIcon)))),
                !!title && react_1.default.createElement(exports.TopAppBarTitle, null, title),
                startContent),
            (!!actionItems || endContent) && (react_1.default.createElement(exports.TopAppBarSection, { alignEnd: true },
                endContent,
                !!actionItems &&
                    actionItems.map(function (actionItemProps, index) { return (react_1.default.createElement(exports.TopAppBarActionItem, tslib_1.__assign({}, actionItemProps, { key: index }))); }))))));
});
/** A row for the app bar. */
exports.TopAppBarRow = base_1.createComponent(function TopAppBarRow(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-top-app-bar__row']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** A section for the app bar. */
exports.TopAppBarSection = base_1.createComponent(function TopAppBarSection(props, ref) {
    var alignStart = props.alignStart, alignEnd = props.alignEnd, rest = tslib_1.__rest(props, ["alignStart", "alignEnd"]);
    var className = base_1.useClassNames(props, [
        'mdc-top-app-bar__section',
        {
            'mdc-top-app-bar__section--align-start': alignStart,
            'mdc-top-app-bar__section--align-end': alignEnd
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({ tag: "section" }, rest, { ref: ref, className: className }));
});
/** A navigation icon for the top app bar. This is an instance of the IconButton component. */
exports.TopAppBarNavigationIcon = base_1.createComponent(function TopAppBarNavigationIcon(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-top-app-bar__navigation-icon']);
    return react_1.default.createElement(icon_button_1.IconButton, tslib_1.__assign({}, props, { className: className, ref: ref }));
});
/** Action items for the top app bar. This is an instance of the IconButton component.*/
exports.TopAppBarActionItem = base_1.createComponent(function TopAppBarActionItem(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-top-app-bar__action-item']);
    return react_1.default.createElement(icon_button_1.IconButton, tslib_1.__assign({}, props, { className: className, ref: ref }));
});
/** A title for the top app bar. */
exports.TopAppBarTitle = base_1.createComponent(function TopAppBarTitle(props, ref) {
    var className = base_1.useClassNames(props, ['mdc-top-app-bar__title']);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, props, { ref: ref, className: className }));
});
/** An optional component to fill the space when the TopAppBar is fixed. Place it directly after the TopAppBar. */
exports.TopAppBarFixedAdjust = base_1.createComponent(function TopAppBarFixedAdjust(props, ref) {
    var dense = props.dense, denseProminent = props.denseProminent, prominent = props.prominent, short = props.short, rest = tslib_1.__rest(props, ["dense", "denseProminent", "prominent", "short"]);
    var className = base_1.useClassNames(props, [
        {
            'mdc-top-app-bar--fixed-adjust': !props.dense && !props.denseProminent && !props.prominent && !props.short,
            'mdc-top-app-bar--dense-fixed-adjust': props.dense,
            'mdc-top-app-bar--prominent-fixed-adjust': props.prominent,
            'mdc-top-app-bar--dense-prominent-fixed-adjust': props.denseProminent,
            'mdc-top-app-bar--short-fixed-adjust': props.short
        }
    ]);
    return react_1.default.createElement(base_1.Tag, tslib_1.__assign({}, rest, { ref: ref, className: className }));
});
